/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.managedgrafana.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.managedgrafana.model.AssertionAttributes;
import com.amazonaws.services.managedgrafana.model.IdpMetadata;
import com.amazonaws.services.managedgrafana.model.RoleValues;
import com.amazonaws.services.managedgrafana.model.transform.SamlConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SamlConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> allowedOrganizations;
    private AssertionAttributes assertionAttributes;
    private IdpMetadata idpMetadata;
    private Integer loginValidityDuration;
    private RoleValues roleValues;

    public List<String> getAllowedOrganizations() {
        return this.allowedOrganizations;
    }

    public void setAllowedOrganizations(Collection<String> allowedOrganizations) {
        if (allowedOrganizations == null) {
            this.allowedOrganizations = null;
            return;
        }
        this.allowedOrganizations = new ArrayList<String>(allowedOrganizations);
    }

    public SamlConfiguration withAllowedOrganizations(String ... allowedOrganizations) {
        if (this.allowedOrganizations == null) {
            this.setAllowedOrganizations(new ArrayList<String>(allowedOrganizations.length));
        }
        for (String ele : allowedOrganizations) {
            this.allowedOrganizations.add(ele);
        }
        return this;
    }

    public SamlConfiguration withAllowedOrganizations(Collection<String> allowedOrganizations) {
        this.setAllowedOrganizations(allowedOrganizations);
        return this;
    }

    public void setAssertionAttributes(AssertionAttributes assertionAttributes) {
        this.assertionAttributes = assertionAttributes;
    }

    public AssertionAttributes getAssertionAttributes() {
        return this.assertionAttributes;
    }

    public SamlConfiguration withAssertionAttributes(AssertionAttributes assertionAttributes) {
        this.setAssertionAttributes(assertionAttributes);
        return this;
    }

    public void setIdpMetadata(IdpMetadata idpMetadata) {
        this.idpMetadata = idpMetadata;
    }

    public IdpMetadata getIdpMetadata() {
        return this.idpMetadata;
    }

    public SamlConfiguration withIdpMetadata(IdpMetadata idpMetadata) {
        this.setIdpMetadata(idpMetadata);
        return this;
    }

    public void setLoginValidityDuration(Integer loginValidityDuration) {
        this.loginValidityDuration = loginValidityDuration;
    }

    public Integer getLoginValidityDuration() {
        return this.loginValidityDuration;
    }

    public SamlConfiguration withLoginValidityDuration(Integer loginValidityDuration) {
        this.setLoginValidityDuration(loginValidityDuration);
        return this;
    }

    public void setRoleValues(RoleValues roleValues) {
        this.roleValues = roleValues;
    }

    public RoleValues getRoleValues() {
        return this.roleValues;
    }

    public SamlConfiguration withRoleValues(RoleValues roleValues) {
        this.setRoleValues(roleValues);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAllowedOrganizations() != null) {
            sb.append("AllowedOrganizations: ").append(this.getAllowedOrganizations()).append(",");
        }
        if (this.getAssertionAttributes() != null) {
            sb.append("AssertionAttributes: ").append(this.getAssertionAttributes()).append(",");
        }
        if (this.getIdpMetadata() != null) {
            sb.append("IdpMetadata: ").append(this.getIdpMetadata()).append(",");
        }
        if (this.getLoginValidityDuration() != null) {
            sb.append("LoginValidityDuration: ").append(this.getLoginValidityDuration()).append(",");
        }
        if (this.getRoleValues() != null) {
            sb.append("RoleValues: ").append(this.getRoleValues());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SamlConfiguration)) {
            return false;
        }
        SamlConfiguration other = (SamlConfiguration)obj;
        if (other.getAllowedOrganizations() == null ^ this.getAllowedOrganizations() == null) {
            return false;
        }
        if (other.getAllowedOrganizations() != null && !other.getAllowedOrganizations().equals(this.getAllowedOrganizations())) {
            return false;
        }
        if (other.getAssertionAttributes() == null ^ this.getAssertionAttributes() == null) {
            return false;
        }
        if (other.getAssertionAttributes() != null && !other.getAssertionAttributes().equals(this.getAssertionAttributes())) {
            return false;
        }
        if (other.getIdpMetadata() == null ^ this.getIdpMetadata() == null) {
            return false;
        }
        if (other.getIdpMetadata() != null && !other.getIdpMetadata().equals(this.getIdpMetadata())) {
            return false;
        }
        if (other.getLoginValidityDuration() == null ^ this.getLoginValidityDuration() == null) {
            return false;
        }
        if (other.getLoginValidityDuration() != null && !other.getLoginValidityDuration().equals(this.getLoginValidityDuration())) {
            return false;
        }
        if (other.getRoleValues() == null ^ this.getRoleValues() == null) {
            return false;
        }
        return other.getRoleValues() == null || other.getRoleValues().equals(this.getRoleValues());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAllowedOrganizations() == null ? 0 : this.getAllowedOrganizations().hashCode());
        hashCode = 31 * hashCode + (this.getAssertionAttributes() == null ? 0 : this.getAssertionAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getIdpMetadata() == null ? 0 : this.getIdpMetadata().hashCode());
        hashCode = 31 * hashCode + (this.getLoginValidityDuration() == null ? 0 : this.getLoginValidityDuration().hashCode());
        hashCode = 31 * hashCode + (this.getRoleValues() == null ? 0 : this.getRoleValues().hashCode());
        return hashCode;
    }

    public SamlConfiguration clone() {
        try {
            return (SamlConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SamlConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

