/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.managedblockchain.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.managedblockchain.model.AccessorNetworkType;
import com.amazonaws.services.managedblockchain.model.AccessorType;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class CreateAccessorRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String clientRequestToken;
    private String accessorType;
    private Map<String, String> tags;
    private String networkType;

    public void setClientRequestToken(String clientRequestToken) {
        this.clientRequestToken = clientRequestToken;
    }

    public String getClientRequestToken() {
        return this.clientRequestToken;
    }

    public CreateAccessorRequest withClientRequestToken(String clientRequestToken) {
        this.setClientRequestToken(clientRequestToken);
        return this;
    }

    public void setAccessorType(String accessorType) {
        this.accessorType = accessorType;
    }

    public String getAccessorType() {
        return this.accessorType;
    }

    public CreateAccessorRequest withAccessorType(String accessorType) {
        this.setAccessorType(accessorType);
        return this;
    }

    public CreateAccessorRequest withAccessorType(AccessorType accessorType) {
        this.accessorType = accessorType.toString();
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateAccessorRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateAccessorRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateAccessorRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setNetworkType(String networkType) {
        this.networkType = networkType;
    }

    public String getNetworkType() {
        return this.networkType;
    }

    public CreateAccessorRequest withNetworkType(String networkType) {
        this.setNetworkType(networkType);
        return this;
    }

    public CreateAccessorRequest withNetworkType(AccessorNetworkType networkType) {
        this.networkType = networkType.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClientRequestToken() != null) {
            sb.append("ClientRequestToken: ").append(this.getClientRequestToken()).append(",");
        }
        if (this.getAccessorType() != null) {
            sb.append("AccessorType: ").append(this.getAccessorType()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getNetworkType() != null) {
            sb.append("NetworkType: ").append(this.getNetworkType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccessorRequest)) {
            return false;
        }
        CreateAccessorRequest other = (CreateAccessorRequest)obj;
        if (other.getClientRequestToken() == null ^ this.getClientRequestToken() == null) {
            return false;
        }
        if (other.getClientRequestToken() != null && !other.getClientRequestToken().equals(this.getClientRequestToken())) {
            return false;
        }
        if (other.getAccessorType() == null ^ this.getAccessorType() == null) {
            return false;
        }
        if (other.getAccessorType() != null && !other.getAccessorType().equals(this.getAccessorType())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getNetworkType() == null ^ this.getNetworkType() == null) {
            return false;
        }
        return other.getNetworkType() == null || other.getNetworkType().equals(this.getNetworkType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClientRequestToken() == null ? 0 : this.getClientRequestToken().hashCode());
        hashCode = 31 * hashCode + (this.getAccessorType() == null ? 0 : this.getAccessorType().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkType() == null ? 0 : this.getNetworkType().hashCode());
        return hashCode;
    }

    public CreateAccessorRequest clone() {
        return (CreateAccessorRequest)super.clone();
    }
}

