/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.mainframemodernization.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.mainframemodernization.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * JobStepRestartMarkerMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class JobStepRestartMarkerMarshaller {

    private static final MarshallingInfo<String> FROMPROCSTEP_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fromProcStep").build();
    private static final MarshallingInfo<String> FROMSTEP_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("fromStep").build();
    private static final MarshallingInfo<String> TOPROCSTEP_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("toProcStep").build();
    private static final MarshallingInfo<String> TOSTEP_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("toStep").build();

    private static final JobStepRestartMarkerMarshaller instance = new JobStepRestartMarkerMarshaller();

    public static JobStepRestartMarkerMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(JobStepRestartMarker jobStepRestartMarker, ProtocolMarshaller protocolMarshaller) {

        if (jobStepRestartMarker == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(jobStepRestartMarker.getFromProcStep(), FROMPROCSTEP_BINDING);
            protocolMarshaller.marshall(jobStepRestartMarker.getFromStep(), FROMSTEP_BINDING);
            protocolMarshaller.marshall(jobStepRestartMarker.getToProcStep(), TOPROCSTEP_BINDING);
            protocolMarshaller.marshall(jobStepRestartMarker.getToStep(), TOSTEP_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
