/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.lakeformation.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Configuration for enabling external data filtering for third-party applications to access data managed by Lake
 * Formation .
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/lakeformation-2017-03-31/ExternalFilteringConfiguration"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ExternalFilteringConfiguration implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * Allows to enable or disable the third-party applications that are allowed to access data managed by Lake
     * Formation.
     * </p>
     */
    private String status;
    /**
     * <p>
     * List of third-party application <code>ARNs</code> integrated with Lake Formation.
     * </p>
     */
    private java.util.List<String> authorizedTargets;

    /**
     * <p>
     * Allows to enable or disable the third-party applications that are allowed to access data managed by Lake
     * Formation.
     * </p>
     * 
     * @param status
     *        Allows to enable or disable the third-party applications that are allowed to access data managed by Lake
     *        Formation.
     * @see EnableStatus
     */

    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * <p>
     * Allows to enable or disable the third-party applications that are allowed to access data managed by Lake
     * Formation.
     * </p>
     * 
     * @return Allows to enable or disable the third-party applications that are allowed to access data managed by Lake
     *         Formation.
     * @see EnableStatus
     */

    public String getStatus() {
        return this.status;
    }

    /**
     * <p>
     * Allows to enable or disable the third-party applications that are allowed to access data managed by Lake
     * Formation.
     * </p>
     * 
     * @param status
     *        Allows to enable or disable the third-party applications that are allowed to access data managed by Lake
     *        Formation.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see EnableStatus
     */

    public ExternalFilteringConfiguration withStatus(String status) {
        setStatus(status);
        return this;
    }

    /**
     * <p>
     * Allows to enable or disable the third-party applications that are allowed to access data managed by Lake
     * Formation.
     * </p>
     * 
     * @param status
     *        Allows to enable or disable the third-party applications that are allowed to access data managed by Lake
     *        Formation.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see EnableStatus
     */

    public ExternalFilteringConfiguration withStatus(EnableStatus status) {
        this.status = status.toString();
        return this;
    }

    /**
     * <p>
     * List of third-party application <code>ARNs</code> integrated with Lake Formation.
     * </p>
     * 
     * @return List of third-party application <code>ARNs</code> integrated with Lake Formation.
     */

    public java.util.List<String> getAuthorizedTargets() {
        return authorizedTargets;
    }

    /**
     * <p>
     * List of third-party application <code>ARNs</code> integrated with Lake Formation.
     * </p>
     * 
     * @param authorizedTargets
     *        List of third-party application <code>ARNs</code> integrated with Lake Formation.
     */

    public void setAuthorizedTargets(java.util.Collection<String> authorizedTargets) {
        if (authorizedTargets == null) {
            this.authorizedTargets = null;
            return;
        }

        this.authorizedTargets = new java.util.ArrayList<String>(authorizedTargets);
    }

    /**
     * <p>
     * List of third-party application <code>ARNs</code> integrated with Lake Formation.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setAuthorizedTargets(java.util.Collection)} or {@link #withAuthorizedTargets(java.util.Collection)} if
     * you want to override the existing values.
     * </p>
     * 
     * @param authorizedTargets
     *        List of third-party application <code>ARNs</code> integrated with Lake Formation.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ExternalFilteringConfiguration withAuthorizedTargets(String... authorizedTargets) {
        if (this.authorizedTargets == null) {
            setAuthorizedTargets(new java.util.ArrayList<String>(authorizedTargets.length));
        }
        for (String ele : authorizedTargets) {
            this.authorizedTargets.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * List of third-party application <code>ARNs</code> integrated with Lake Formation.
     * </p>
     * 
     * @param authorizedTargets
     *        List of third-party application <code>ARNs</code> integrated with Lake Formation.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ExternalFilteringConfiguration withAuthorizedTargets(java.util.Collection<String> authorizedTargets) {
        setAuthorizedTargets(authorizedTargets);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getStatus() != null)
            sb.append("Status: ").append(getStatus()).append(",");
        if (getAuthorizedTargets() != null)
            sb.append("AuthorizedTargets: ").append(getAuthorizedTargets());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ExternalFilteringConfiguration == false)
            return false;
        ExternalFilteringConfiguration other = (ExternalFilteringConfiguration) obj;
        if (other.getStatus() == null ^ this.getStatus() == null)
            return false;
        if (other.getStatus() != null && other.getStatus().equals(this.getStatus()) == false)
            return false;
        if (other.getAuthorizedTargets() == null ^ this.getAuthorizedTargets() == null)
            return false;
        if (other.getAuthorizedTargets() != null && other.getAuthorizedTargets().equals(this.getAuthorizedTargets()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getStatus() == null) ? 0 : getStatus().hashCode());
        hashCode = prime * hashCode + ((getAuthorizedTargets() == null) ? 0 : getAuthorizedTargets().hashCode());
        return hashCode;
    }

    @Override
    public ExternalFilteringConfiguration clone() {
        try {
            return (ExternalFilteringConfiguration) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.lakeformation.model.transform.ExternalFilteringConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
