/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalyticsv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.kinesisanalyticsv2.model.PropertyGroup;
import java.util.Map;

@SdkInternalApi
public class PropertyGroupMarshaller {
    private static final MarshallingInfo<String> PROPERTYGROUPID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PropertyGroupId").build();
    private static final MarshallingInfo<Map> PROPERTYMAP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PropertyMap").build();
    private static final PropertyGroupMarshaller instance = new PropertyGroupMarshaller();

    public static PropertyGroupMarshaller getInstance() {
        return instance;
    }

    public void marshall(PropertyGroup propertyGroup, ProtocolMarshaller protocolMarshaller) {
        if (propertyGroup == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)propertyGroup.getPropertyGroupId(), PROPERTYGROUPID_BINDING);
            protocolMarshaller.marshall(propertyGroup.getPropertyMap(), PROPERTYMAP_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

