/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotdeviceadvisor.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotdeviceadvisor.model.TestCaseRun;
import com.amazonaws.services.iotdeviceadvisor.model.transform.GroupResultMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GroupResult
implements Serializable,
Cloneable,
StructuredPojo {
    private String groupId;
    private String groupName;
    private List<TestCaseRun> tests;

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public GroupResult withGroupId(String groupId) {
        this.setGroupId(groupId);
        return this;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public GroupResult withGroupName(String groupName) {
        this.setGroupName(groupName);
        return this;
    }

    public List<TestCaseRun> getTests() {
        return this.tests;
    }

    public void setTests(Collection<TestCaseRun> tests) {
        if (tests == null) {
            this.tests = null;
            return;
        }
        this.tests = new ArrayList<TestCaseRun>(tests);
    }

    public GroupResult withTests(TestCaseRun ... tests) {
        if (this.tests == null) {
            this.setTests(new ArrayList<TestCaseRun>(tests.length));
        }
        for (TestCaseRun ele : tests) {
            this.tests.add(ele);
        }
        return this;
    }

    public GroupResult withTests(Collection<TestCaseRun> tests) {
        this.setTests(tests);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGroupId() != null) {
            sb.append("GroupId: ").append(this.getGroupId()).append(",");
        }
        if (this.getGroupName() != null) {
            sb.append("GroupName: ").append(this.getGroupName()).append(",");
        }
        if (this.getTests() != null) {
            sb.append("Tests: ").append(this.getTests());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupResult)) {
            return false;
        }
        GroupResult other = (GroupResult)obj;
        if (other.getGroupId() == null ^ this.getGroupId() == null) {
            return false;
        }
        if (other.getGroupId() != null && !other.getGroupId().equals(this.getGroupId())) {
            return false;
        }
        if (other.getGroupName() == null ^ this.getGroupName() == null) {
            return false;
        }
        if (other.getGroupName() != null && !other.getGroupName().equals(this.getGroupName())) {
            return false;
        }
        if (other.getTests() == null ^ this.getTests() == null) {
            return false;
        }
        return other.getTests() == null || other.getTests().equals(this.getTests());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGroupId() == null ? 0 : this.getGroupId().hashCode());
        hashCode = 31 * hashCode + (this.getGroupName() == null ? 0 : this.getGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getTests() == null ? 0 : this.getTests().hashCode());
        return hashCode;
    }

    public GroupResult clone() {
        try {
            return (GroupResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GroupResultMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

