/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.iot.model.ThingDocument;
import com.amazonaws.services.iot.model.ThingGroupDocument;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SearchIndexResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<ThingDocument> things;
    private List<ThingGroupDocument> thingGroups;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public SearchIndexResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<ThingDocument> getThings() {
        return this.things;
    }

    public void setThings(Collection<ThingDocument> things) {
        if (things == null) {
            this.things = null;
            return;
        }
        this.things = new ArrayList<ThingDocument>(things);
    }

    public SearchIndexResult withThings(ThingDocument ... things) {
        if (this.things == null) {
            this.setThings(new ArrayList<ThingDocument>(things.length));
        }
        for (ThingDocument ele : things) {
            this.things.add(ele);
        }
        return this;
    }

    public SearchIndexResult withThings(Collection<ThingDocument> things) {
        this.setThings(things);
        return this;
    }

    public List<ThingGroupDocument> getThingGroups() {
        return this.thingGroups;
    }

    public void setThingGroups(Collection<ThingGroupDocument> thingGroups) {
        if (thingGroups == null) {
            this.thingGroups = null;
            return;
        }
        this.thingGroups = new ArrayList<ThingGroupDocument>(thingGroups);
    }

    public SearchIndexResult withThingGroups(ThingGroupDocument ... thingGroups) {
        if (this.thingGroups == null) {
            this.setThingGroups(new ArrayList<ThingGroupDocument>(thingGroups.length));
        }
        for (ThingGroupDocument ele : thingGroups) {
            this.thingGroups.add(ele);
        }
        return this;
    }

    public SearchIndexResult withThingGroups(Collection<ThingGroupDocument> thingGroups) {
        this.setThingGroups(thingGroups);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getThings() != null) {
            sb.append("Things: ").append(this.getThings()).append(",");
        }
        if (this.getThingGroups() != null) {
            sb.append("ThingGroups: ").append(this.getThingGroups());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchIndexResult)) {
            return false;
        }
        SearchIndexResult other = (SearchIndexResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getThings() == null ^ this.getThings() == null) {
            return false;
        }
        if (other.getThings() != null && !other.getThings().equals(this.getThings())) {
            return false;
        }
        if (other.getThingGroups() == null ^ this.getThingGroups() == null) {
            return false;
        }
        return other.getThingGroups() == null || other.getThingGroups().equals(this.getThingGroups());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getThings() == null ? 0 : this.getThings().hashCode());
        hashCode = 31 * hashCode + (this.getThingGroups() == null ? 0 : this.getThingGroups().hashCode());
        return hashCode;
    }

    public SearchIndexResult clone() {
        try {
            return (SearchIndexResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

