/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.frauddetector.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.frauddetector.model.Entity;
import com.amazonaws.services.frauddetector.model.ModelEndpointDataBlob;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GetEventPredictionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String detectorId;
    private String detectorVersionId;
    private String eventId;
    private String eventTypeName;
    private List<Entity> entities;
    private String eventTimestamp;
    private Map<String, String> eventVariables;
    private Map<String, ModelEndpointDataBlob> externalModelEndpointDataBlobs;

    public void setDetectorId(String detectorId) {
        this.detectorId = detectorId;
    }

    public String getDetectorId() {
        return this.detectorId;
    }

    public GetEventPredictionRequest withDetectorId(String detectorId) {
        this.setDetectorId(detectorId);
        return this;
    }

    public void setDetectorVersionId(String detectorVersionId) {
        this.detectorVersionId = detectorVersionId;
    }

    public String getDetectorVersionId() {
        return this.detectorVersionId;
    }

    public GetEventPredictionRequest withDetectorVersionId(String detectorVersionId) {
        this.setDetectorVersionId(detectorVersionId);
        return this;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public String getEventId() {
        return this.eventId;
    }

    public GetEventPredictionRequest withEventId(String eventId) {
        this.setEventId(eventId);
        return this;
    }

    public void setEventTypeName(String eventTypeName) {
        this.eventTypeName = eventTypeName;
    }

    public String getEventTypeName() {
        return this.eventTypeName;
    }

    public GetEventPredictionRequest withEventTypeName(String eventTypeName) {
        this.setEventTypeName(eventTypeName);
        return this;
    }

    public List<Entity> getEntities() {
        return this.entities;
    }

    public void setEntities(Collection<Entity> entities) {
        if (entities == null) {
            this.entities = null;
            return;
        }
        this.entities = new ArrayList<Entity>(entities);
    }

    public GetEventPredictionRequest withEntities(Entity ... entities) {
        if (this.entities == null) {
            this.setEntities(new ArrayList<Entity>(entities.length));
        }
        for (Entity ele : entities) {
            this.entities.add(ele);
        }
        return this;
    }

    public GetEventPredictionRequest withEntities(Collection<Entity> entities) {
        this.setEntities(entities);
        return this;
    }

    public void setEventTimestamp(String eventTimestamp) {
        this.eventTimestamp = eventTimestamp;
    }

    public String getEventTimestamp() {
        return this.eventTimestamp;
    }

    public GetEventPredictionRequest withEventTimestamp(String eventTimestamp) {
        this.setEventTimestamp(eventTimestamp);
        return this;
    }

    public Map<String, String> getEventVariables() {
        return this.eventVariables;
    }

    public void setEventVariables(Map<String, String> eventVariables) {
        this.eventVariables = eventVariables;
    }

    public GetEventPredictionRequest withEventVariables(Map<String, String> eventVariables) {
        this.setEventVariables(eventVariables);
        return this;
    }

    public GetEventPredictionRequest addEventVariablesEntry(String key, String value) {
        if (null == this.eventVariables) {
            this.eventVariables = new HashMap<String, String>();
        }
        if (this.eventVariables.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.eventVariables.put(key, value);
        return this;
    }

    public GetEventPredictionRequest clearEventVariablesEntries() {
        this.eventVariables = null;
        return this;
    }

    public Map<String, ModelEndpointDataBlob> getExternalModelEndpointDataBlobs() {
        return this.externalModelEndpointDataBlobs;
    }

    public void setExternalModelEndpointDataBlobs(Map<String, ModelEndpointDataBlob> externalModelEndpointDataBlobs) {
        this.externalModelEndpointDataBlobs = externalModelEndpointDataBlobs;
    }

    public GetEventPredictionRequest withExternalModelEndpointDataBlobs(Map<String, ModelEndpointDataBlob> externalModelEndpointDataBlobs) {
        this.setExternalModelEndpointDataBlobs(externalModelEndpointDataBlobs);
        return this;
    }

    public GetEventPredictionRequest addExternalModelEndpointDataBlobsEntry(String key, ModelEndpointDataBlob value) {
        if (null == this.externalModelEndpointDataBlobs) {
            this.externalModelEndpointDataBlobs = new HashMap<String, ModelEndpointDataBlob>();
        }
        if (this.externalModelEndpointDataBlobs.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.externalModelEndpointDataBlobs.put(key, value);
        return this;
    }

    public GetEventPredictionRequest clearExternalModelEndpointDataBlobsEntries() {
        this.externalModelEndpointDataBlobs = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDetectorId() != null) {
            sb.append("DetectorId: ").append(this.getDetectorId()).append(",");
        }
        if (this.getDetectorVersionId() != null) {
            sb.append("DetectorVersionId: ").append(this.getDetectorVersionId()).append(",");
        }
        if (this.getEventId() != null) {
            sb.append("EventId: ").append(this.getEventId()).append(",");
        }
        if (this.getEventTypeName() != null) {
            sb.append("EventTypeName: ").append(this.getEventTypeName()).append(",");
        }
        if (this.getEntities() != null) {
            sb.append("Entities: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getEventTimestamp() != null) {
            sb.append("EventTimestamp: ").append(this.getEventTimestamp()).append(",");
        }
        if (this.getEventVariables() != null) {
            sb.append("EventVariables: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getExternalModelEndpointDataBlobs() != null) {
            sb.append("ExternalModelEndpointDataBlobs: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEventPredictionRequest)) {
            return false;
        }
        GetEventPredictionRequest other = (GetEventPredictionRequest)obj;
        if (other.getDetectorId() == null ^ this.getDetectorId() == null) {
            return false;
        }
        if (other.getDetectorId() != null && !other.getDetectorId().equals(this.getDetectorId())) {
            return false;
        }
        if (other.getDetectorVersionId() == null ^ this.getDetectorVersionId() == null) {
            return false;
        }
        if (other.getDetectorVersionId() != null && !other.getDetectorVersionId().equals(this.getDetectorVersionId())) {
            return false;
        }
        if (other.getEventId() == null ^ this.getEventId() == null) {
            return false;
        }
        if (other.getEventId() != null && !other.getEventId().equals(this.getEventId())) {
            return false;
        }
        if (other.getEventTypeName() == null ^ this.getEventTypeName() == null) {
            return false;
        }
        if (other.getEventTypeName() != null && !other.getEventTypeName().equals(this.getEventTypeName())) {
            return false;
        }
        if (other.getEntities() == null ^ this.getEntities() == null) {
            return false;
        }
        if (other.getEntities() != null && !other.getEntities().equals(this.getEntities())) {
            return false;
        }
        if (other.getEventTimestamp() == null ^ this.getEventTimestamp() == null) {
            return false;
        }
        if (other.getEventTimestamp() != null && !other.getEventTimestamp().equals(this.getEventTimestamp())) {
            return false;
        }
        if (other.getEventVariables() == null ^ this.getEventVariables() == null) {
            return false;
        }
        if (other.getEventVariables() != null && !other.getEventVariables().equals(this.getEventVariables())) {
            return false;
        }
        if (other.getExternalModelEndpointDataBlobs() == null ^ this.getExternalModelEndpointDataBlobs() == null) {
            return false;
        }
        return other.getExternalModelEndpointDataBlobs() == null || other.getExternalModelEndpointDataBlobs().equals(this.getExternalModelEndpointDataBlobs());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDetectorId() == null ? 0 : this.getDetectorId().hashCode());
        hashCode = 31 * hashCode + (this.getDetectorVersionId() == null ? 0 : this.getDetectorVersionId().hashCode());
        hashCode = 31 * hashCode + (this.getEventId() == null ? 0 : this.getEventId().hashCode());
        hashCode = 31 * hashCode + (this.getEventTypeName() == null ? 0 : this.getEventTypeName().hashCode());
        hashCode = 31 * hashCode + (this.getEntities() == null ? 0 : this.getEntities().hashCode());
        hashCode = 31 * hashCode + (this.getEventTimestamp() == null ? 0 : this.getEventTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getEventVariables() == null ? 0 : this.getEventVariables().hashCode());
        hashCode = 31 * hashCode + (this.getExternalModelEndpointDataBlobs() == null ? 0 : this.getExternalModelEndpointDataBlobs().hashCode());
        return hashCode;
    }

    public GetEventPredictionRequest clone() {
        return (GetEventPredictionRequest)super.clone();
    }
}

