/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.forecast.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.forecast.model.Action;
import com.amazonaws.services.forecast.model.TimeSeriesCondition;
import com.amazonaws.services.forecast.model.transform.TimeSeriesTransformationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TimeSeriesTransformation
implements Serializable,
Cloneable,
StructuredPojo {
    private Action action;
    private List<TimeSeriesCondition> timeSeriesConditions;

    public void setAction(Action action) {
        this.action = action;
    }

    public Action getAction() {
        return this.action;
    }

    public TimeSeriesTransformation withAction(Action action) {
        this.setAction(action);
        return this;
    }

    public List<TimeSeriesCondition> getTimeSeriesConditions() {
        return this.timeSeriesConditions;
    }

    public void setTimeSeriesConditions(Collection<TimeSeriesCondition> timeSeriesConditions) {
        if (timeSeriesConditions == null) {
            this.timeSeriesConditions = null;
            return;
        }
        this.timeSeriesConditions = new ArrayList<TimeSeriesCondition>(timeSeriesConditions);
    }

    public TimeSeriesTransformation withTimeSeriesConditions(TimeSeriesCondition ... timeSeriesConditions) {
        if (this.timeSeriesConditions == null) {
            this.setTimeSeriesConditions(new ArrayList<TimeSeriesCondition>(timeSeriesConditions.length));
        }
        for (TimeSeriesCondition ele : timeSeriesConditions) {
            this.timeSeriesConditions.add(ele);
        }
        return this;
    }

    public TimeSeriesTransformation withTimeSeriesConditions(Collection<TimeSeriesCondition> timeSeriesConditions) {
        this.setTimeSeriesConditions(timeSeriesConditions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAction() != null) {
            sb.append("Action: ").append(this.getAction()).append(",");
        }
        if (this.getTimeSeriesConditions() != null) {
            sb.append("TimeSeriesConditions: ").append(this.getTimeSeriesConditions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeSeriesTransformation)) {
            return false;
        }
        TimeSeriesTransformation other = (TimeSeriesTransformation)obj;
        if (other.getAction() == null ^ this.getAction() == null) {
            return false;
        }
        if (other.getAction() != null && !other.getAction().equals(this.getAction())) {
            return false;
        }
        if (other.getTimeSeriesConditions() == null ^ this.getTimeSeriesConditions() == null) {
            return false;
        }
        return other.getTimeSeriesConditions() == null || other.getTimeSeriesConditions().equals(this.getTimeSeriesConditions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAction() == null ? 0 : this.getAction().hashCode());
        hashCode = 31 * hashCode + (this.getTimeSeriesConditions() == null ? 0 : this.getTimeSeriesConditions().hashCode());
        return hashCode;
    }

    public TimeSeriesTransformation clone() {
        try {
            return (TimeSeriesTransformation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TimeSeriesTransformationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

