/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.elasticloadbalancingv2.model.transform;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.Request;
import com.amazonaws.DefaultRequest;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticloadbalancingv2.model.*;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

/**
 * DescribeTrustStoreAssociationsRequest Marshaller
 */

@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DescribeTrustStoreAssociationsRequestMarshaller implements
        Marshaller<Request<DescribeTrustStoreAssociationsRequest>, DescribeTrustStoreAssociationsRequest> {

    public Request<DescribeTrustStoreAssociationsRequest> marshall(DescribeTrustStoreAssociationsRequest describeTrustStoreAssociationsRequest) {

        if (describeTrustStoreAssociationsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<DescribeTrustStoreAssociationsRequest> request = new DefaultRequest<DescribeTrustStoreAssociationsRequest>(
                describeTrustStoreAssociationsRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "DescribeTrustStoreAssociations");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (describeTrustStoreAssociationsRequest.getTrustStoreArn() != null) {
            request.addParameter("TrustStoreArn", StringUtils.fromString(describeTrustStoreAssociationsRequest.getTrustStoreArn()));
        }

        if (describeTrustStoreAssociationsRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString(describeTrustStoreAssociationsRequest.getMarker()));
        }

        if (describeTrustStoreAssociationsRequest.getPageSize() != null) {
            request.addParameter("PageSize", StringUtils.fromInteger(describeTrustStoreAssociationsRequest.getPageSize()));
        }

        return request;
    }

}
