/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devopsguru.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.devopsguru.model.EventClass;
import com.amazonaws.services.devopsguru.model.EventDataSource;
import com.amazonaws.services.devopsguru.model.EventResource;
import com.amazonaws.services.devopsguru.model.ResourceCollection;
import com.amazonaws.services.devopsguru.model.transform.EventMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Event
implements Serializable,
Cloneable,
StructuredPojo {
    private ResourceCollection resourceCollection;
    private String id;
    private Date time;
    private String eventSource;
    private String name;
    private String dataSource;
    private String eventClass;
    private List<EventResource> resources;

    public void setResourceCollection(ResourceCollection resourceCollection) {
        this.resourceCollection = resourceCollection;
    }

    public ResourceCollection getResourceCollection() {
        return this.resourceCollection;
    }

    public Event withResourceCollection(ResourceCollection resourceCollection) {
        this.setResourceCollection(resourceCollection);
        return this;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Event withId(String id) {
        this.setId(id);
        return this;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public Date getTime() {
        return this.time;
    }

    public Event withTime(Date time) {
        this.setTime(time);
        return this;
    }

    public void setEventSource(String eventSource) {
        this.eventSource = eventSource;
    }

    public String getEventSource() {
        return this.eventSource;
    }

    public Event withEventSource(String eventSource) {
        this.setEventSource(eventSource);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Event withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public Event withDataSource(String dataSource) {
        this.setDataSource(dataSource);
        return this;
    }

    public Event withDataSource(EventDataSource dataSource) {
        this.dataSource = dataSource.toString();
        return this;
    }

    public void setEventClass(String eventClass) {
        this.eventClass = eventClass;
    }

    public String getEventClass() {
        return this.eventClass;
    }

    public Event withEventClass(String eventClass) {
        this.setEventClass(eventClass);
        return this;
    }

    public Event withEventClass(EventClass eventClass) {
        this.eventClass = eventClass.toString();
        return this;
    }

    public List<EventResource> getResources() {
        return this.resources;
    }

    public void setResources(Collection<EventResource> resources) {
        if (resources == null) {
            this.resources = null;
            return;
        }
        this.resources = new ArrayList<EventResource>(resources);
    }

    public Event withResources(EventResource ... resources) {
        if (this.resources == null) {
            this.setResources(new ArrayList<EventResource>(resources.length));
        }
        for (EventResource ele : resources) {
            this.resources.add(ele);
        }
        return this;
    }

    public Event withResources(Collection<EventResource> resources) {
        this.setResources(resources);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceCollection() != null) {
            sb.append("ResourceCollection: ").append(this.getResourceCollection()).append(",");
        }
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getTime() != null) {
            sb.append("Time: ").append(this.getTime()).append(",");
        }
        if (this.getEventSource() != null) {
            sb.append("EventSource: ").append(this.getEventSource()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDataSource() != null) {
            sb.append("DataSource: ").append(this.getDataSource()).append(",");
        }
        if (this.getEventClass() != null) {
            sb.append("EventClass: ").append(this.getEventClass()).append(",");
        }
        if (this.getResources() != null) {
            sb.append("Resources: ").append(this.getResources());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Event)) {
            return false;
        }
        Event other = (Event)obj;
        if (other.getResourceCollection() == null ^ this.getResourceCollection() == null) {
            return false;
        }
        if (other.getResourceCollection() != null && !other.getResourceCollection().equals(this.getResourceCollection())) {
            return false;
        }
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getTime() == null ^ this.getTime() == null) {
            return false;
        }
        if (other.getTime() != null && !other.getTime().equals(this.getTime())) {
            return false;
        }
        if (other.getEventSource() == null ^ this.getEventSource() == null) {
            return false;
        }
        if (other.getEventSource() != null && !other.getEventSource().equals(this.getEventSource())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDataSource() == null ^ this.getDataSource() == null) {
            return false;
        }
        if (other.getDataSource() != null && !other.getDataSource().equals(this.getDataSource())) {
            return false;
        }
        if (other.getEventClass() == null ^ this.getEventClass() == null) {
            return false;
        }
        if (other.getEventClass() != null && !other.getEventClass().equals(this.getEventClass())) {
            return false;
        }
        if (other.getResources() == null ^ this.getResources() == null) {
            return false;
        }
        return other.getResources() == null || other.getResources().equals(this.getResources());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceCollection() == null ? 0 : this.getResourceCollection().hashCode());
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getTime() == null ? 0 : this.getTime().hashCode());
        hashCode = 31 * hashCode + (this.getEventSource() == null ? 0 : this.getEventSource().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDataSource() == null ? 0 : this.getDataSource().hashCode());
        hashCode = 31 * hashCode + (this.getEventClass() == null ? 0 : this.getEventClass().hashCode());
        hashCode = 31 * hashCode + (this.getResources() == null ? 0 : this.getResources().hashCode());
        return hashCode;
    }

    public Event clone() {
        try {
            return (Event)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EventMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

