/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.costoptimizationhub;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.costoptimizationhub.AWSCostOptimizationHubAsync;
import com.amazonaws.services.costoptimizationhub.AWSCostOptimizationHubAsyncClientBuilder;
import com.amazonaws.services.costoptimizationhub.AWSCostOptimizationHubClient;
import com.amazonaws.services.costoptimizationhub.model.GetPreferencesRequest;
import com.amazonaws.services.costoptimizationhub.model.GetPreferencesResult;
import com.amazonaws.services.costoptimizationhub.model.GetRecommendationRequest;
import com.amazonaws.services.costoptimizationhub.model.GetRecommendationResult;
import com.amazonaws.services.costoptimizationhub.model.ListEnrollmentStatusesRequest;
import com.amazonaws.services.costoptimizationhub.model.ListEnrollmentStatusesResult;
import com.amazonaws.services.costoptimizationhub.model.ListRecommendationSummariesRequest;
import com.amazonaws.services.costoptimizationhub.model.ListRecommendationSummariesResult;
import com.amazonaws.services.costoptimizationhub.model.ListRecommendationsRequest;
import com.amazonaws.services.costoptimizationhub.model.ListRecommendationsResult;
import com.amazonaws.services.costoptimizationhub.model.UpdateEnrollmentStatusRequest;
import com.amazonaws.services.costoptimizationhub.model.UpdateEnrollmentStatusResult;
import com.amazonaws.services.costoptimizationhub.model.UpdatePreferencesRequest;
import com.amazonaws.services.costoptimizationhub.model.UpdatePreferencesResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSCostOptimizationHubAsyncClient
extends AWSCostOptimizationHubClient
implements AWSCostOptimizationHubAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSCostOptimizationHubAsyncClientBuilder asyncBuilder() {
        return AWSCostOptimizationHubAsyncClientBuilder.standard();
    }

    AWSCostOptimizationHubAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSCostOptimizationHubAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<GetPreferencesResult> getPreferencesAsync(GetPreferencesRequest request) {
        return this.getPreferencesAsync(request, null);
    }

    @Override
    public Future<GetPreferencesResult> getPreferencesAsync(GetPreferencesRequest request, final AsyncHandler<GetPreferencesRequest, GetPreferencesResult> asyncHandler) {
        final GetPreferencesRequest finalRequest = (GetPreferencesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetPreferencesResult>(){

            @Override
            public GetPreferencesResult call() throws Exception {
                GetPreferencesResult result = null;
                try {
                    result = AWSCostOptimizationHubAsyncClient.this.executeGetPreferences(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetRecommendationResult> getRecommendationAsync(GetRecommendationRequest request) {
        return this.getRecommendationAsync(request, null);
    }

    @Override
    public Future<GetRecommendationResult> getRecommendationAsync(GetRecommendationRequest request, final AsyncHandler<GetRecommendationRequest, GetRecommendationResult> asyncHandler) {
        final GetRecommendationRequest finalRequest = (GetRecommendationRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetRecommendationResult>(){

            @Override
            public GetRecommendationResult call() throws Exception {
                GetRecommendationResult result = null;
                try {
                    result = AWSCostOptimizationHubAsyncClient.this.executeGetRecommendation(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListEnrollmentStatusesResult> listEnrollmentStatusesAsync(ListEnrollmentStatusesRequest request) {
        return this.listEnrollmentStatusesAsync(request, null);
    }

    @Override
    public Future<ListEnrollmentStatusesResult> listEnrollmentStatusesAsync(ListEnrollmentStatusesRequest request, final AsyncHandler<ListEnrollmentStatusesRequest, ListEnrollmentStatusesResult> asyncHandler) {
        final ListEnrollmentStatusesRequest finalRequest = (ListEnrollmentStatusesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListEnrollmentStatusesResult>(){

            @Override
            public ListEnrollmentStatusesResult call() throws Exception {
                ListEnrollmentStatusesResult result = null;
                try {
                    result = AWSCostOptimizationHubAsyncClient.this.executeListEnrollmentStatuses(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListRecommendationSummariesResult> listRecommendationSummariesAsync(ListRecommendationSummariesRequest request) {
        return this.listRecommendationSummariesAsync(request, null);
    }

    @Override
    public Future<ListRecommendationSummariesResult> listRecommendationSummariesAsync(ListRecommendationSummariesRequest request, final AsyncHandler<ListRecommendationSummariesRequest, ListRecommendationSummariesResult> asyncHandler) {
        final ListRecommendationSummariesRequest finalRequest = (ListRecommendationSummariesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListRecommendationSummariesResult>(){

            @Override
            public ListRecommendationSummariesResult call() throws Exception {
                ListRecommendationSummariesResult result = null;
                try {
                    result = AWSCostOptimizationHubAsyncClient.this.executeListRecommendationSummaries(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListRecommendationsResult> listRecommendationsAsync(ListRecommendationsRequest request) {
        return this.listRecommendationsAsync(request, null);
    }

    @Override
    public Future<ListRecommendationsResult> listRecommendationsAsync(ListRecommendationsRequest request, final AsyncHandler<ListRecommendationsRequest, ListRecommendationsResult> asyncHandler) {
        final ListRecommendationsRequest finalRequest = (ListRecommendationsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListRecommendationsResult>(){

            @Override
            public ListRecommendationsResult call() throws Exception {
                ListRecommendationsResult result = null;
                try {
                    result = AWSCostOptimizationHubAsyncClient.this.executeListRecommendations(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateEnrollmentStatusResult> updateEnrollmentStatusAsync(UpdateEnrollmentStatusRequest request) {
        return this.updateEnrollmentStatusAsync(request, null);
    }

    @Override
    public Future<UpdateEnrollmentStatusResult> updateEnrollmentStatusAsync(UpdateEnrollmentStatusRequest request, final AsyncHandler<UpdateEnrollmentStatusRequest, UpdateEnrollmentStatusResult> asyncHandler) {
        final UpdateEnrollmentStatusRequest finalRequest = (UpdateEnrollmentStatusRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateEnrollmentStatusResult>(){

            @Override
            public UpdateEnrollmentStatusResult call() throws Exception {
                UpdateEnrollmentStatusResult result = null;
                try {
                    result = AWSCostOptimizationHubAsyncClient.this.executeUpdateEnrollmentStatus(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdatePreferencesResult> updatePreferencesAsync(UpdatePreferencesRequest request) {
        return this.updatePreferencesAsync(request, null);
    }

    @Override
    public Future<UpdatePreferencesResult> updatePreferencesAsync(UpdatePreferencesRequest request, final AsyncHandler<UpdatePreferencesRequest, UpdatePreferencesResult> asyncHandler) {
        final UpdatePreferencesRequest finalRequest = (UpdatePreferencesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdatePreferencesResult>(){

            @Override
            public UpdatePreferencesResult call() throws Exception {
                UpdatePreferencesResult result = null;
                try {
                    result = AWSCostOptimizationHubAsyncClient.this.executeUpdatePreferences(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

