/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.connect.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeContactFlowModule" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DescribeContactFlowModuleResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * Information about the flow module.
     * </p>
     */
    private ContactFlowModule contactFlowModule;

    /**
     * <p>
     * Information about the flow module.
     * </p>
     * 
     * @param contactFlowModule
     *        Information about the flow module.
     */

    public void setContactFlowModule(ContactFlowModule contactFlowModule) {
        this.contactFlowModule = contactFlowModule;
    }

    /**
     * <p>
     * Information about the flow module.
     * </p>
     * 
     * @return Information about the flow module.
     */

    public ContactFlowModule getContactFlowModule() {
        return this.contactFlowModule;
    }

    /**
     * <p>
     * Information about the flow module.
     * </p>
     * 
     * @param contactFlowModule
     *        Information about the flow module.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeContactFlowModuleResult withContactFlowModule(ContactFlowModule contactFlowModule) {
        setContactFlowModule(contactFlowModule);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getContactFlowModule() != null)
            sb.append("ContactFlowModule: ").append(getContactFlowModule());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DescribeContactFlowModuleResult == false)
            return false;
        DescribeContactFlowModuleResult other = (DescribeContactFlowModuleResult) obj;
        if (other.getContactFlowModule() == null ^ this.getContactFlowModule() == null)
            return false;
        if (other.getContactFlowModule() != null && other.getContactFlowModule().equals(this.getContactFlowModule()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getContactFlowModule() == null) ? 0 : getContactFlowModule().hashCode());
        return hashCode;
    }

    @Override
    public DescribeContactFlowModuleResult clone() {
        try {
            return (DescribeContactFlowModuleResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
