/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codebuild.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.codebuild.model.BuildArtifacts;

@SdkInternalApi
public class BuildArtifactsMarshaller {
    private static final MarshallingInfo<String> LOCATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("location").build();
    private static final MarshallingInfo<String> SHA256SUM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sha256sum").build();
    private static final MarshallingInfo<String> MD5SUM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("md5sum").build();
    private static final MarshallingInfo<Boolean> ENCRYPTIONDISABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("encryptionDisabled").build();
    private static final BuildArtifactsMarshaller instance = new BuildArtifactsMarshaller();

    public static BuildArtifactsMarshaller getInstance() {
        return instance;
    }

    public void marshall(BuildArtifacts buildArtifacts, ProtocolMarshaller protocolMarshaller) {
        if (buildArtifacts == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)buildArtifacts.getLocation(), LOCATION_BINDING);
            protocolMarshaller.marshall((Object)buildArtifacts.getSha256sum(), SHA256SUM_BINDING);
            protocolMarshaller.marshall((Object)buildArtifacts.getMd5sum(), MD5SUM_BINDING);
            protocolMarshaller.marshall((Object)buildArtifacts.getEncryptionDisabled(), ENCRYPTIONDISABLED_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

