/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.bcmdataexports;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.bcmdataexports.AWSBCMDataExportsAsync;
import com.amazonaws.services.bcmdataexports.AWSBCMDataExportsAsyncClientBuilder;
import com.amazonaws.services.bcmdataexports.AWSBCMDataExportsClient;
import com.amazonaws.services.bcmdataexports.model.CreateExportRequest;
import com.amazonaws.services.bcmdataexports.model.CreateExportResult;
import com.amazonaws.services.bcmdataexports.model.DeleteExportRequest;
import com.amazonaws.services.bcmdataexports.model.DeleteExportResult;
import com.amazonaws.services.bcmdataexports.model.GetExecutionRequest;
import com.amazonaws.services.bcmdataexports.model.GetExecutionResult;
import com.amazonaws.services.bcmdataexports.model.GetExportRequest;
import com.amazonaws.services.bcmdataexports.model.GetExportResult;
import com.amazonaws.services.bcmdataexports.model.GetTableRequest;
import com.amazonaws.services.bcmdataexports.model.GetTableResult;
import com.amazonaws.services.bcmdataexports.model.ListExecutionsRequest;
import com.amazonaws.services.bcmdataexports.model.ListExecutionsResult;
import com.amazonaws.services.bcmdataexports.model.ListExportsRequest;
import com.amazonaws.services.bcmdataexports.model.ListExportsResult;
import com.amazonaws.services.bcmdataexports.model.ListTablesRequest;
import com.amazonaws.services.bcmdataexports.model.ListTablesResult;
import com.amazonaws.services.bcmdataexports.model.ListTagsForResourceRequest;
import com.amazonaws.services.bcmdataexports.model.ListTagsForResourceResult;
import com.amazonaws.services.bcmdataexports.model.TagResourceRequest;
import com.amazonaws.services.bcmdataexports.model.TagResourceResult;
import com.amazonaws.services.bcmdataexports.model.UntagResourceRequest;
import com.amazonaws.services.bcmdataexports.model.UntagResourceResult;
import com.amazonaws.services.bcmdataexports.model.UpdateExportRequest;
import com.amazonaws.services.bcmdataexports.model.UpdateExportResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSBCMDataExportsAsyncClient
extends AWSBCMDataExportsClient
implements AWSBCMDataExportsAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSBCMDataExportsAsyncClientBuilder asyncBuilder() {
        return AWSBCMDataExportsAsyncClientBuilder.standard();
    }

    AWSBCMDataExportsAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSBCMDataExportsAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateExportResult> createExportAsync(CreateExportRequest request) {
        return this.createExportAsync(request, null);
    }

    @Override
    public Future<CreateExportResult> createExportAsync(CreateExportRequest request, final AsyncHandler<CreateExportRequest, CreateExportResult> asyncHandler) {
        final CreateExportRequest finalRequest = (CreateExportRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateExportResult>(){

            @Override
            public CreateExportResult call() throws Exception {
                CreateExportResult result = null;
                try {
                    result = AWSBCMDataExportsAsyncClient.this.executeCreateExport(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteExportResult> deleteExportAsync(DeleteExportRequest request) {
        return this.deleteExportAsync(request, null);
    }

    @Override
    public Future<DeleteExportResult> deleteExportAsync(DeleteExportRequest request, final AsyncHandler<DeleteExportRequest, DeleteExportResult> asyncHandler) {
        final DeleteExportRequest finalRequest = (DeleteExportRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteExportResult>(){

            @Override
            public DeleteExportResult call() throws Exception {
                DeleteExportResult result = null;
                try {
                    result = AWSBCMDataExportsAsyncClient.this.executeDeleteExport(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetExecutionResult> getExecutionAsync(GetExecutionRequest request) {
        return this.getExecutionAsync(request, null);
    }

    @Override
    public Future<GetExecutionResult> getExecutionAsync(GetExecutionRequest request, final AsyncHandler<GetExecutionRequest, GetExecutionResult> asyncHandler) {
        final GetExecutionRequest finalRequest = (GetExecutionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetExecutionResult>(){

            @Override
            public GetExecutionResult call() throws Exception {
                GetExecutionResult result = null;
                try {
                    result = AWSBCMDataExportsAsyncClient.this.executeGetExecution(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetExportResult> getExportAsync(GetExportRequest request) {
        return this.getExportAsync(request, null);
    }

    @Override
    public Future<GetExportResult> getExportAsync(GetExportRequest request, final AsyncHandler<GetExportRequest, GetExportResult> asyncHandler) {
        final GetExportRequest finalRequest = (GetExportRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetExportResult>(){

            @Override
            public GetExportResult call() throws Exception {
                GetExportResult result = null;
                try {
                    result = AWSBCMDataExportsAsyncClient.this.executeGetExport(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTableResult> getTableAsync(GetTableRequest request) {
        return this.getTableAsync(request, null);
    }

    @Override
    public Future<GetTableResult> getTableAsync(GetTableRequest request, final AsyncHandler<GetTableRequest, GetTableResult> asyncHandler) {
        final GetTableRequest finalRequest = (GetTableRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetTableResult>(){

            @Override
            public GetTableResult call() throws Exception {
                GetTableResult result = null;
                try {
                    result = AWSBCMDataExportsAsyncClient.this.executeGetTable(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListExecutionsResult> listExecutionsAsync(ListExecutionsRequest request) {
        return this.listExecutionsAsync(request, null);
    }

    @Override
    public Future<ListExecutionsResult> listExecutionsAsync(ListExecutionsRequest request, final AsyncHandler<ListExecutionsRequest, ListExecutionsResult> asyncHandler) {
        final ListExecutionsRequest finalRequest = (ListExecutionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListExecutionsResult>(){

            @Override
            public ListExecutionsResult call() throws Exception {
                ListExecutionsResult result = null;
                try {
                    result = AWSBCMDataExportsAsyncClient.this.executeListExecutions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListExportsResult> listExportsAsync(ListExportsRequest request) {
        return this.listExportsAsync(request, null);
    }

    @Override
    public Future<ListExportsResult> listExportsAsync(ListExportsRequest request, final AsyncHandler<ListExportsRequest, ListExportsResult> asyncHandler) {
        final ListExportsRequest finalRequest = (ListExportsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListExportsResult>(){

            @Override
            public ListExportsResult call() throws Exception {
                ListExportsResult result = null;
                try {
                    result = AWSBCMDataExportsAsyncClient.this.executeListExports(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTablesResult> listTablesAsync(ListTablesRequest request) {
        return this.listTablesAsync(request, null);
    }

    @Override
    public Future<ListTablesResult> listTablesAsync(ListTablesRequest request, final AsyncHandler<ListTablesRequest, ListTablesResult> asyncHandler) {
        final ListTablesRequest finalRequest = (ListTablesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTablesResult>(){

            @Override
            public ListTablesResult call() throws Exception {
                ListTablesResult result = null;
                try {
                    result = AWSBCMDataExportsAsyncClient.this.executeListTables(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSBCMDataExportsAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AWSBCMDataExportsAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AWSBCMDataExportsAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateExportResult> updateExportAsync(UpdateExportRequest request) {
        return this.updateExportAsync(request, null);
    }

    @Override
    public Future<UpdateExportResult> updateExportAsync(UpdateExportRequest request, final AsyncHandler<UpdateExportRequest, UpdateExportResult> asyncHandler) {
        final UpdateExportRequest finalRequest = (UpdateExportRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateExportResult>(){

            @Override
            public UpdateExportResult call() throws Exception {
                UpdateExportResult result = null;
                try {
                    result = AWSBCMDataExportsAsyncClient.this.executeUpdateExport(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

