/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.artifact;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.artifact.AWSArtifact;
import com.amazonaws.services.artifact.AWSArtifactClientBuilder;
import com.amazonaws.services.artifact.model.AWSArtifactException;
import com.amazonaws.services.artifact.model.GetAccountSettingsRequest;
import com.amazonaws.services.artifact.model.GetAccountSettingsResult;
import com.amazonaws.services.artifact.model.GetReportMetadataRequest;
import com.amazonaws.services.artifact.model.GetReportMetadataResult;
import com.amazonaws.services.artifact.model.GetReportRequest;
import com.amazonaws.services.artifact.model.GetReportResult;
import com.amazonaws.services.artifact.model.GetTermForReportRequest;
import com.amazonaws.services.artifact.model.GetTermForReportResult;
import com.amazonaws.services.artifact.model.ListReportsRequest;
import com.amazonaws.services.artifact.model.ListReportsResult;
import com.amazonaws.services.artifact.model.PutAccountSettingsRequest;
import com.amazonaws.services.artifact.model.PutAccountSettingsResult;
import com.amazonaws.services.artifact.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.artifact.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.artifact.model.transform.GetAccountSettingsRequestProtocolMarshaller;
import com.amazonaws.services.artifact.model.transform.GetAccountSettingsResultJsonUnmarshaller;
import com.amazonaws.services.artifact.model.transform.GetReportMetadataRequestProtocolMarshaller;
import com.amazonaws.services.artifact.model.transform.GetReportMetadataResultJsonUnmarshaller;
import com.amazonaws.services.artifact.model.transform.GetReportRequestProtocolMarshaller;
import com.amazonaws.services.artifact.model.transform.GetReportResultJsonUnmarshaller;
import com.amazonaws.services.artifact.model.transform.GetTermForReportRequestProtocolMarshaller;
import com.amazonaws.services.artifact.model.transform.GetTermForReportResultJsonUnmarshaller;
import com.amazonaws.services.artifact.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.artifact.model.transform.ListReportsRequestProtocolMarshaller;
import com.amazonaws.services.artifact.model.transform.ListReportsResultJsonUnmarshaller;
import com.amazonaws.services.artifact.model.transform.PutAccountSettingsRequestProtocolMarshaller;
import com.amazonaws.services.artifact.model.transform.PutAccountSettingsResultJsonUnmarshaller;
import com.amazonaws.services.artifact.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.artifact.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.artifact.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.artifact.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSArtifactClient
extends AmazonWebServiceClient
implements AWSArtifact {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSArtifact.class);
    private static final String DEFAULT_SIGNING_NAME = "artifact";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSArtifactException.class));

    public static AWSArtifactClientBuilder builder() {
        return AWSArtifactClientBuilder.standard();
    }

    AWSArtifactClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSArtifactClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("artifact.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/artifact/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/artifact/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public GetAccountSettingsResult getAccountSettings(GetAccountSettingsRequest request) {
        request = (GetAccountSettingsRequest)this.beforeClientExecution(request);
        return this.executeGetAccountSettings(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetAccountSettingsResult executeGetAccountSettings(GetAccountSettingsRequest getAccountSettingsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getAccountSettingsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetAccountSettingsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetAccountSettingsRequestProtocolMarshaller(protocolFactory).marshall((GetAccountSettingsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getAccountSettingsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Artifact");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetAccountSettings");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetAccountSettingsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetAccountSettingsResult getAccountSettingsResult = (GetAccountSettingsResult)response.getAwsResponse();
            return getAccountSettingsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetReportResult getReport(GetReportRequest request) {
        request = (GetReportRequest)this.beforeClientExecution(request);
        return this.executeGetReport(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetReportResult executeGetReport(GetReportRequest getReportRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getReportRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetReportRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetReportRequestProtocolMarshaller(protocolFactory).marshall((GetReportRequest)super.beforeMarshalling((AmazonWebServiceRequest)getReportRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Artifact");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetReport");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetReportResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetReportResult getReportResult = (GetReportResult)response.getAwsResponse();
            return getReportResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetReportMetadataResult getReportMetadata(GetReportMetadataRequest request) {
        request = (GetReportMetadataRequest)this.beforeClientExecution(request);
        return this.executeGetReportMetadata(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetReportMetadataResult executeGetReportMetadata(GetReportMetadataRequest getReportMetadataRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getReportMetadataRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetReportMetadataRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetReportMetadataRequestProtocolMarshaller(protocolFactory).marshall((GetReportMetadataRequest)super.beforeMarshalling((AmazonWebServiceRequest)getReportMetadataRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Artifact");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetReportMetadata");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetReportMetadataResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetReportMetadataResult getReportMetadataResult = (GetReportMetadataResult)response.getAwsResponse();
            return getReportMetadataResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetTermForReportResult getTermForReport(GetTermForReportRequest request) {
        request = (GetTermForReportRequest)this.beforeClientExecution(request);
        return this.executeGetTermForReport(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetTermForReportResult executeGetTermForReport(GetTermForReportRequest getTermForReportRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getTermForReportRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetTermForReportRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetTermForReportRequestProtocolMarshaller(protocolFactory).marshall((GetTermForReportRequest)super.beforeMarshalling((AmazonWebServiceRequest)getTermForReportRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Artifact");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetTermForReport");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetTermForReportResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetTermForReportResult getTermForReportResult = (GetTermForReportResult)response.getAwsResponse();
            return getTermForReportResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListReportsResult listReports(ListReportsRequest request) {
        request = (ListReportsRequest)this.beforeClientExecution(request);
        return this.executeListReports(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListReportsResult executeListReports(ListReportsRequest listReportsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listReportsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListReportsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListReportsRequestProtocolMarshaller(protocolFactory).marshall((ListReportsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listReportsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Artifact");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListReports");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListReportsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListReportsResult listReportsResult = (ListReportsResult)response.getAwsResponse();
            return listReportsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutAccountSettingsResult putAccountSettings(PutAccountSettingsRequest request) {
        request = (PutAccountSettingsRequest)this.beforeClientExecution(request);
        return this.executePutAccountSettings(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutAccountSettingsResult executePutAccountSettings(PutAccountSettingsRequest putAccountSettingsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putAccountSettingsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutAccountSettingsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutAccountSettingsRequestProtocolMarshaller(protocolFactory).marshall((PutAccountSettingsRequest)super.beforeMarshalling((AmazonWebServiceRequest)putAccountSettingsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Artifact");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutAccountSettings");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutAccountSettingsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutAccountSettingsResult putAccountSettingsResult = (PutAccountSettingsResult)response.getAwsResponse();
            return putAccountSettingsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

