/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.appflow.model.transform;

import java.util.Map;

import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.appflow.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * ConnectorEntityFieldMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class ConnectorEntityFieldMarshaller {

    private static final MarshallingInfo<String> IDENTIFIER_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("identifier").build();
    private static final MarshallingInfo<String> PARENTIDENTIFIER_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("parentIdentifier").build();
    private static final MarshallingInfo<String> LABEL_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("label").build();
    private static final MarshallingInfo<Boolean> ISPRIMARYKEY_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("isPrimaryKey").build();
    private static final MarshallingInfo<String> DEFAULTVALUE_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("defaultValue").build();
    private static final MarshallingInfo<Boolean> ISDEPRECATED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("isDeprecated").build();
    private static final MarshallingInfo<StructuredPojo> SUPPORTEDFIELDTYPEDETAILS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("supportedFieldTypeDetails").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").build();
    private static final MarshallingInfo<StructuredPojo> SOURCEPROPERTIES_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sourceProperties").build();
    private static final MarshallingInfo<StructuredPojo> DESTINATIONPROPERTIES_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("destinationProperties").build();
    private static final MarshallingInfo<Map> CUSTOMPROPERTIES_BINDING = MarshallingInfo.builder(MarshallingType.MAP)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("customProperties").build();

    private static final ConnectorEntityFieldMarshaller instance = new ConnectorEntityFieldMarshaller();

    public static ConnectorEntityFieldMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(ConnectorEntityField connectorEntityField, ProtocolMarshaller protocolMarshaller) {

        if (connectorEntityField == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(connectorEntityField.getIdentifier(), IDENTIFIER_BINDING);
            protocolMarshaller.marshall(connectorEntityField.getParentIdentifier(), PARENTIDENTIFIER_BINDING);
            protocolMarshaller.marshall(connectorEntityField.getLabel(), LABEL_BINDING);
            protocolMarshaller.marshall(connectorEntityField.getIsPrimaryKey(), ISPRIMARYKEY_BINDING);
            protocolMarshaller.marshall(connectorEntityField.getDefaultValue(), DEFAULTVALUE_BINDING);
            protocolMarshaller.marshall(connectorEntityField.getIsDeprecated(), ISDEPRECATED_BINDING);
            protocolMarshaller.marshall(connectorEntityField.getSupportedFieldTypeDetails(), SUPPORTEDFIELDTYPEDETAILS_BINDING);
            protocolMarshaller.marshall(connectorEntityField.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(connectorEntityField.getSourceProperties(), SOURCEPROPERTIES_BINDING);
            protocolMarshaller.marshall(connectorEntityField.getDestinationProperties(), DESTINATIONPROPERTIES_BINDING);
            protocolMarshaller.marshall(connectorEntityField.getCustomProperties(), CUSTOMPROPERTIES_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
