/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqs.javamessaging.acknowledge;

import com.amazon.sqs.javamessaging.acknowledge.SQSMessageIdentifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;

public abstract class BulkSQSOperation {
    public void bulkAction(List<SQSMessageIdentifier> messageIdentifierList, int indexOfMessage) throws JMSException {
        assert (indexOfMessage > 0);
        assert (indexOfMessage <= messageIdentifierList.size());
        HashMap<String, ArrayList<String>> receiptHandleWithSameQueueUrl = new HashMap<String, ArrayList<String>>();
        for (int i = 0; i < indexOfMessage; ++i) {
            SQSMessageIdentifier messageIdentifier = messageIdentifierList.get(i);
            String queueUrl = messageIdentifier.getQueueUrl();
            ArrayList<String> receiptHandles = (ArrayList<String>)receiptHandleWithSameQueueUrl.get(queueUrl);
            if (receiptHandles == null) {
                receiptHandles = new ArrayList<String>();
                receiptHandleWithSameQueueUrl.put(queueUrl, receiptHandles);
            }
            receiptHandles.add(messageIdentifier.getReceiptHandle());
            if (receiptHandles.size() != 10) continue;
            this.action(queueUrl, receiptHandles);
            receiptHandles.clear();
        }
        for (Map.Entry entry : receiptHandleWithSameQueueUrl.entrySet()) {
            this.action((String)entry.getKey(), (List)entry.getValue());
        }
    }

    public abstract void action(String var1, List<String> var2) throws JMSException;
}

