/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.leases.impl;

import com.amazonaws.services.kinesis.model.HashKeyRange;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import java.math.BigInteger;
import lombok.NonNull;
import org.apache.commons.lang3.Validate;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public final class HashKeyRangeForLease {
    private final BigInteger startingHashKey;
    private final BigInteger endingHashKey;

    public String serializedStartingHashKey() {
        return this.startingHashKey.toString();
    }

    public String serializedEndingHashKey() {
        return this.endingHashKey.toString();
    }

    public static HashKeyRangeForLease deserialize(@NonNull String startingHashKeyStr, @NonNull String endingHashKeyStr) {
        if (startingHashKeyStr == null) {
            throw new NullPointerException("startingHashKeyStr is marked non-null but is null");
        }
        if (endingHashKeyStr == null) {
            throw new NullPointerException("endingHashKeyStr is marked non-null but is null");
        }
        BigInteger startingHashKey = new BigInteger(startingHashKeyStr);
        BigInteger endingHashKey = new BigInteger(endingHashKeyStr);
        Validate.isTrue((startingHashKey.compareTo(endingHashKey) < 0 ? 1 : 0) != 0, (String)"StartingHashKey %s must be less than EndingHashKey %s ", (Object[])new Object[]{startingHashKeyStr, endingHashKeyStr});
        return new HashKeyRangeForLease(startingHashKey, endingHashKey);
    }

    public static HashKeyRangeForLease fromHashKeyRange(HashKeyRange hashKeyRange) {
        return HashKeyRangeForLease.deserialize(hashKeyRange.getStartingHashKey(), hashKeyRange.getEndingHashKey());
    }

    public HashKeyRangeForLease(BigInteger startingHashKey, BigInteger endingHashKey) {
        this.startingHashKey = startingHashKey;
        this.endingHashKey = endingHashKey;
    }

    public BigInteger startingHashKey() {
        return this.startingHashKey;
    }

    public BigInteger endingHashKey() {
        return this.endingHashKey;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HashKeyRangeForLease)) {
            return false;
        }
        HashKeyRangeForLease other = (HashKeyRangeForLease)o;
        BigInteger this$startingHashKey = this.startingHashKey();
        BigInteger other$startingHashKey = other.startingHashKey();
        if (this$startingHashKey == null ? other$startingHashKey != null : !((Object)this$startingHashKey).equals(other$startingHashKey)) {
            return false;
        }
        BigInteger this$endingHashKey = this.endingHashKey();
        BigInteger other$endingHashKey = other.endingHashKey();
        return !(this$endingHashKey == null ? other$endingHashKey != null : !((Object)this$endingHashKey).equals(other$endingHashKey));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigInteger $startingHashKey = this.startingHashKey();
        result = result * 59 + ($startingHashKey == null ? 43 : ((Object)$startingHashKey).hashCode());
        BigInteger $endingHashKey = this.endingHashKey();
        result = result * 59 + ($endingHashKey == null ? 43 : ((Object)$endingHashKey).hashCode());
        return result;
    }

    public String toString() {
        return "HashKeyRangeForLease(startingHashKey=" + this.startingHashKey() + ", endingHashKey=" + this.endingHashKey() + ")";
    }
}

