/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.viewport;

import com.amazon.ask.model.interfaces.viewport.TypedViewportState;
import com.amazon.ask.model.interfaces.viewport.aplt.CharacterFormat;
import com.amazon.ask.model.interfaces.viewport.aplt.InterSegment;
import com.amazon.ask.model.interfaces.viewport.aplt.ViewportProfile;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class APLTViewportState
extends TypedViewportState {
    @JsonProperty(value="supportedProfiles")
    private List<ViewportProfile> supportedProfiles = new ArrayList<ViewportProfile>();
    @JsonProperty(value="lineLength")
    private Integer lineLength = null;
    @JsonProperty(value="lineCount")
    private Integer lineCount = null;
    @JsonProperty(value="characterFormat")
    private CharacterFormat characterFormat = null;
    @JsonProperty(value="interSegments")
    private List<InterSegment> interSegments = new ArrayList<InterSegment>();

    private APLTViewportState() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private APLTViewportState(Builder builder) {
        String discriminatorValue = "APLT";
        if (builder.id != null) {
            this.id = builder.id;
        }
        this.type = discriminatorValue;
        if (builder.supportedProfiles != null) {
            this.supportedProfiles = builder.supportedProfiles;
        }
        if (builder.lineLength != null) {
            this.lineLength = builder.lineLength;
        }
        if (builder.lineCount != null) {
            this.lineCount = builder.lineCount;
        }
        if (builder.characterFormat != null) {
            this.characterFormat = builder.characterFormat;
        }
        if (builder.interSegments != null) {
            this.interSegments = builder.interSegments;
        }
    }

    @JsonProperty(value="supportedProfiles")
    public List<ViewportProfile> getSupportedProfiles() {
        return this.supportedProfiles;
    }

    @JsonProperty(value="lineLength")
    public Integer getLineLength() {
        return this.lineLength;
    }

    @JsonProperty(value="lineCount")
    public Integer getLineCount() {
        return this.lineCount;
    }

    @JsonProperty(value="characterFormat")
    public CharacterFormat getCharacterFormat() {
        return this.characterFormat;
    }

    @JsonProperty(value="interSegments")
    public List<InterSegment> getInterSegments() {
        return this.interSegments;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        APLTViewportState interfacesViewportAPLTViewportState = (APLTViewportState)o;
        return Objects.equals(this.supportedProfiles, interfacesViewportAPLTViewportState.supportedProfiles) && Objects.equals(this.lineLength, interfacesViewportAPLTViewportState.lineLength) && Objects.equals(this.lineCount, interfacesViewportAPLTViewportState.lineCount) && Objects.equals((Object)this.characterFormat, (Object)interfacesViewportAPLTViewportState.characterFormat) && Objects.equals(this.interSegments, interfacesViewportAPLTViewportState.interSegments) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.supportedProfiles, this.lineLength, this.lineCount, this.characterFormat, this.interSegments, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class APLTViewportState {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    supportedProfiles: ").append(this.toIndentedString(this.supportedProfiles)).append("\n");
        sb.append("    lineLength: ").append(this.toIndentedString(this.lineLength)).append("\n");
        sb.append("    lineCount: ").append(this.toIndentedString(this.lineCount)).append("\n");
        sb.append("    characterFormat: ").append(this.toIndentedString((Object)this.characterFormat)).append("\n");
        sb.append("    interSegments: ").append(this.toIndentedString(this.interSegments)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String id;
        private List<ViewportProfile> supportedProfiles;
        private Integer lineLength;
        private Integer lineCount;
        private CharacterFormat characterFormat;
        private List<InterSegment> interSegments;

        private Builder() {
        }

        @JsonProperty(value="id")
        public Builder withId(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="supportedProfiles")
        public Builder withSupportedProfiles(List<ViewportProfile> supportedProfiles) {
            this.supportedProfiles = supportedProfiles;
            return this;
        }

        public Builder addSupportedProfilesItem(ViewportProfile supportedProfilesItem) {
            if (this.supportedProfiles == null) {
                this.supportedProfiles = new ArrayList<ViewportProfile>();
            }
            this.supportedProfiles.add(supportedProfilesItem);
            return this;
        }

        @JsonProperty(value="lineLength")
        public Builder withLineLength(Integer lineLength) {
            this.lineLength = lineLength;
            return this;
        }

        @JsonProperty(value="lineCount")
        public Builder withLineCount(Integer lineCount) {
            this.lineCount = lineCount;
            return this;
        }

        @JsonProperty(value="characterFormat")
        public Builder withCharacterFormat(CharacterFormat characterFormat) {
            this.characterFormat = characterFormat;
            return this;
        }

        @JsonProperty(value="interSegments")
        public Builder withInterSegments(List<InterSegment> interSegments) {
            this.interSegments = interSegments;
            return this;
        }

        public Builder addInterSegmentsItem(InterSegment interSegmentsItem) {
            if (this.interSegments == null) {
                this.interSegments = new ArrayList<InterSegment>();
            }
            this.interSegments.add(interSegmentsItem);
            return this;
        }

        public APLTViewportState build() {
            return new APLTViewportState(this);
        }
    }
}

