/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ask.model.interfaces.alexa.datastore.packagemanager;

import com.amazon.ask.model.Request;
import com.amazon.ask.model.interfaces.alexa.datastore.packagemanager.PackageError;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
public final class InstallationError
extends Request {
    @JsonProperty(value="packageId")
    private String packageId = null;
    @JsonProperty(value="version")
    private String version = null;
    @JsonProperty(value="error")
    private PackageError error = null;

    private InstallationError() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private InstallationError(Builder builder) {
        String discriminatorValue;
        this.type = discriminatorValue = "Alexa.DataStore.PackageManager.InstallationError";
        if (builder.requestId != null) {
            this.requestId = builder.requestId;
        }
        if (builder.timestamp != null) {
            this.timestamp = builder.timestamp;
        }
        if (builder.locale != null) {
            this.locale = builder.locale;
        }
        if (builder.packageId != null) {
            this.packageId = builder.packageId;
        }
        if (builder.version != null) {
            this.version = builder.version;
        }
        if (builder.error != null) {
            this.error = builder.error;
        }
    }

    @JsonProperty(value="packageId")
    public String getPackageId() {
        return this.packageId;
    }

    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="error")
    public PackageError getError() {
        return this.error;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstallationError interfacesAlexaDatastorePackagemanagerInstallationError = (InstallationError)o;
        return Objects.equals(this.packageId, interfacesAlexaDatastorePackagemanagerInstallationError.packageId) && Objects.equals(this.version, interfacesAlexaDatastorePackagemanagerInstallationError.version) && Objects.equals(this.error, interfacesAlexaDatastorePackagemanagerInstallationError.error) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.packageId, this.version, this.error, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InstallationError {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    packageId: ").append(this.toIndentedString(this.packageId)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static class Builder {
        private String requestId;
        private OffsetDateTime timestamp;
        private String locale;
        private String packageId;
        private String version;
        private PackageError error;

        private Builder() {
        }

        @JsonProperty(value="requestId")
        public Builder withRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @JsonProperty(value="timestamp")
        public Builder withTimestamp(OffsetDateTime timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @JsonProperty(value="locale")
        public Builder withLocale(String locale) {
            this.locale = locale;
            return this;
        }

        @JsonProperty(value="packageId")
        public Builder withPackageId(String packageId) {
            this.packageId = packageId;
            return this;
        }

        @JsonProperty(value="version")
        public Builder withVersion(String version) {
            this.version = version;
            return this;
        }

        @JsonProperty(value="error")
        public Builder withError(PackageError error) {
            this.error = error;
            return this;
        }

        public InstallationError build() {
            return new InstallationError(this);
        }
    }
}

