/*
 * Decompiled with CFR 0.152.
 */
package com.akathist.maven.plugins.launch4j;

import java.util.HashMap;
import java.util.Map;
import net.sf.launch4j.config.LanguageID;
import org.apache.maven.plugins.annotations.Parameter;

public class VersionInfo {
    private static final Map<String, LanguageID> LANGUAGE_TO_LANGUAGE_ID = new HashMap<String, LanguageID>();
    @Parameter
    String fileVersion;
    @Parameter
    String txtFileVersion;
    @Parameter
    String fileDescription;
    @Parameter
    String copyright;
    @Parameter
    String productVersion;
    @Parameter
    String txtProductVersion;
    @Parameter
    String productName;
    @Parameter
    String companyName;
    @Parameter
    String internalName;
    @Parameter
    String originalFilename;
    @Parameter
    String language = LanguageID.ENGLISH_US.name();
    @Parameter
    String trademarks;

    net.sf.launch4j.config.VersionInfo toL4j() {
        net.sf.launch4j.config.VersionInfo ret = new net.sf.launch4j.config.VersionInfo();
        ret.setFileVersion(this.fileVersion);
        ret.setTxtFileVersion(this.txtFileVersion);
        ret.setFileDescription(this.fileDescription);
        ret.setCopyright(this.copyright);
        ret.setProductVersion(this.productVersion);
        ret.setTxtProductVersion(this.txtProductVersion);
        ret.setProductName(this.productName);
        ret.setCompanyName(this.companyName);
        ret.setInternalName(this.internalName);
        ret.setOriginalFilename(this.originalFilename);
        this.setLanguage(ret);
        ret.setTrademarks(this.trademarks);
        return ret;
    }

    private void setLanguage(net.sf.launch4j.config.VersionInfo ret) {
        LanguageID languageID = LANGUAGE_TO_LANGUAGE_ID.get(this.language);
        if (languageID == null) {
            languageID = LanguageID.ENGLISH_US;
        }
        ret.setLanguage(languageID);
    }

    public String toString() {
        return "VersionInfo{fileVersion='" + this.fileVersion + '\'' + ", txtFileVersion='" + this.txtFileVersion + '\'' + ", fileDescription='" + this.fileDescription + '\'' + ", copyright='" + this.copyright + '\'' + ", productVersion='" + this.productVersion + '\'' + ", txtProductVersion='" + this.txtProductVersion + '\'' + ", productName='" + this.productName + '\'' + ", companyName='" + this.companyName + '\'' + ", internalName='" + this.internalName + '\'' + ", originalFilename='" + this.originalFilename + '\'' + ", language='" + this.language + '\'' + ", trademarks='" + this.trademarks + '\'' + '}';
    }

    static {
        for (LanguageID languageID : LanguageID.values()) {
            LANGUAGE_TO_LANGUAGE_ID.put(languageID.name(), languageID);
        }
    }
}

