/*
 * Decompiled with CFR 0.152.
 */
package com.agilejava.maven.docbkx;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import org.codehaus.plexus.util.StringInputStream;

public class EntityFileParser {
    public static void parse(InputStream in, EntityVisitor visitor) throws IOException {
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(in));
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (line.indexOf("SYSTEM") <= -1) continue;
            String[] parts = line.split(" ");
            String name = parts[1];
            String systemId = parts[3].substring(1, parts[3].length() - 2);
            visitor.visitSystemEntity(name, systemId);
        }
    }

    public static final void main(String[] args) {
        StringBuffer builder = new StringBuffer();
        builder.append("<!ENTITY foo SYSTEM \"bar\">\n");
        builder.append("<!ENTITY bar SYSTEM \"foo\">\n");
        StringInputStream in = new StringInputStream(builder.toString());
        try {
            EntityFileParser.parse((InputStream)in, new EntityVisitor(){

                public void visitSystemEntity(String name, String systemId) {
                    System.out.println("Name: " + name);
                    System.out.println("SystemId: " + systemId);
                }
            });
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static interface EntityVisitor {
        public void visitSystemEntity(String var1, String var2);
    }
}

