/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.remote.galaxy;

import co.paralleluniverse.actors.ActorImpl;
import co.paralleluniverse.actors.ActorRef;
import co.paralleluniverse.actors.LifecycleListener;
import co.paralleluniverse.actors.RemoteActor;
import co.paralleluniverse.galaxy.cluster.NodeChangeListener;
import co.paralleluniverse.galaxy.quasar.Grid;
import co.paralleluniverse.remote.galaxy.GlxRemoteActor;
import co.paralleluniverse.remote.galaxy.GlxRemoteChannel;
import co.paralleluniverse.remote.galaxy.RemoteChannelReceiver;
import co.paralleluniverse.strands.channels.QueueChannel;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class GlxNonGlobalRemoteActor<Message>
extends GlxRemoteActor<Message> {
    private static final Grid grid;
    private static final Set<RegistryRecord> listenerRegistry;

    public GlxNonGlobalRemoteActor(ActorRef<Message> actor) {
        super(actor);
        this.startReceiver();
    }

    private void startReceiver() {
        ActorImpl actor = this.getActor();
        if (actor == null) {
            throw new IllegalStateException("Actor for " + (Object)((Object)this) + " not running locally");
        }
        RemoteChannelReceiver<Object> receiver = RemoteChannelReceiver.getReceiver((QueueChannel)this.getActor().getMailbox());
        receiver.setFilter(new RemoteChannelReceiver.MessageFilter<Object>(){

            @Override
            public boolean shouldForwardMessage(Object msg) {
                if (msg instanceof RemoteActor.RemoteActorAdminMessage) {
                    GlxNonGlobalRemoteActor.this.handleAdminMessage((RemoteActor.RemoteActorAdminMessage)msg);
                    return false;
                }
                return true;
            }
        });
    }

    private boolean isNodeAlive() {
        short ownerNodeId = this.getOwnerNodeId();
        return grid.cluster().getMyNodeId() == ownerNodeId || grid.cluster().getNodes().contains(ownerNodeId);
    }

    protected void addLifecycleListener(LifecycleListener listener) {
        if (!this.isNodeAlive()) {
            listener.dead(this.ref(), null);
            return;
        }
        super.addLifecycleListener(listener);
        listenerRegistry.add(new RegistryRecord(listener, this));
    }

    protected void removeLifecycleListener(LifecycleListener listener) {
        super.removeLifecycleListener(listener);
        listenerRegistry.remove(new RegistryRecord(listener, this));
    }

    protected void removeObserverListeners(ActorRef actor) {
        super.removeObserverListeners(actor);
        Iterator<RegistryRecord> it = listenerRegistry.iterator();
        while (it.hasNext()) {
            RegistryRecord registryRecord = it.next();
            if (!registryRecord.actor.equals((Object)this)) continue;
            it.remove();
        }
    }

    short getOwnerNodeId() {
        return (short)((GlxRemoteChannel)this.getMailbox()).getId().getAddress();
    }

    static {
        listenerRegistry = Collections.newSetFromMap(new ConcurrentHashMap());
        try {
            grid = Grid.getInstance();
            grid.cluster().addNodeChangeListener(new NodeChangeListener(){

                public void nodeAdded(short id) {
                }

                public void nodeSwitched(short id) {
                }

                public void nodeRemoved(short id) {
                    Iterator it = listenerRegistry.iterator();
                    while (it.hasNext()) {
                        RegistryRecord registryRecord = (RegistryRecord)it.next();
                        if (registryRecord.getOwnerNodeId() != id) continue;
                        registryRecord.listener.dead(registryRecord.actor.ref(), new Throwable("cluster node removed"));
                        it.remove();
                    }
                }
            });
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    static final class RegistryRecord {
        final LifecycleListener listener;
        final GlxNonGlobalRemoteActor actor;

        public RegistryRecord(LifecycleListener listener, GlxNonGlobalRemoteActor actor) {
            this.listener = listener;
            this.actor = actor;
        }

        short getOwnerNodeId() {
            return this.actor.getOwnerNodeId();
        }

        public int hashCode() {
            int hash = 7;
            hash = 79 * hash + Objects.hashCode(this.listener);
            hash = 79 * hash + Objects.hashCode((Object)this.actor);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof RegistryRecord)) {
                return false;
            }
            RegistryRecord other = (RegistryRecord)obj;
            if (!Objects.equals(this.listener, other.listener)) {
                return false;
            }
            return Objects.equals((Object)this.actor, (Object)other.actor);
        }
    }
}

