/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.remote.galaxy;

import co.paralleluniverse.actors.ActorImpl;
import co.paralleluniverse.actors.ActorRef;
import co.paralleluniverse.actors.RemoteActor;
import co.paralleluniverse.remote.galaxy.GlobalRemoteChannelReceiver;
import co.paralleluniverse.remote.galaxy.GlxRemoteActor;
import java.io.ObjectStreamException;

public class GlxGlobalRemoteActor<Message>
extends GlxRemoteActor<Message> {
    private final long id;

    public GlxGlobalRemoteActor(ActorRef<Message> actor, Object globalId) {
        super(actor);
        this.id = (Long)globalId;
        this.startReceiver();
    }

    private void startReceiver() {
        ActorImpl actor = this.getActor();
        if (actor == null) {
            throw new IllegalStateException("Actor for " + (Object)((Object)this) + " not running locally");
        }
        GlobalRemoteChannelReceiver<Object> receiver = GlobalRemoteChannelReceiver.getReceiver(actor.getMailbox(), this.id);
        receiver.setFilter(new GlobalRemoteChannelReceiver.MessageFilter<Object>(){

            @Override
            public boolean shouldForwardMessage(Object msg) {
                if (msg instanceof RemoteActor.RemoteActorAdminMessage) {
                    GlxGlobalRemoteActor.this.handleAdminMessage((RemoteActor.RemoteActorAdminMessage)msg);
                    return false;
                }
                return true;
            }
        });
    }

    @Override
    protected Object readResolve() throws ObjectStreamException {
        GlxGlobalRemoteActor remote = (GlxGlobalRemoteActor)((Object)super.readResolve());
        return remote;
    }
}

