/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.strands.queues;

import co.paralleluniverse.common.monitoring.FlightRecorder;
import co.paralleluniverse.common.monitoring.FlightRecorderMessage;
import co.paralleluniverse.common.util.Debug;
import co.paralleluniverse.common.util.Objects;
import co.paralleluniverse.strands.queues.BasicSingleConsumerQueue;
import co.paralleluniverse.strands.queues.QueueIterator;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;

public abstract class SingleConsumerQueue<E>
extends AbstractCollection<E>
implements Iterable<E>,
Queue<E>,
BasicSingleConsumerQueue<E> {
    static final FlightRecorder RECORDER = Debug.isDebug() ? Debug.getGlobalFlightRecorder() : null;

    @Override
    public abstract boolean enq(E var1);

    @Override
    public abstract E poll();

    @Override
    public abstract E peek();

    @Override
    public abstract QueueIterator<E> iterator();

    @Override
    public abstract int size();

    public abstract List<E> snapshot();

    @Override
    public abstract int capacity();

    @Override
    public boolean hasNext() {
        return !this.isEmpty();
    }

    @Override
    public abstract boolean isEmpty();

    @Override
    public boolean add(E e) {
        this.enq(e);
        return true;
    }

    @Override
    public final boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean offer(E e) {
        return this.enq(e);
    }

    @Override
    public E remove() {
        E val = this.poll();
        if (val == null) {
            throw new NoSuchElementException();
        }
        return val;
    }

    @Override
    public E element() {
        E val = this.peek();
        if (val == null) {
            throw new NoSuchElementException();
        }
        return val;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Objects.systemToString(this));
        sb.append('[');
        Iterator it = this.iterator();
        while (it.hasNext()) {
            sb.append(it.next()).append(", ");
        }
        if (sb.length() > 1) {
            sb.delete(sb.length() - 2, sb.length());
        }
        sb.append(']');
        return sb.toString();
    }

    boolean isRecording() {
        return RECORDER != null;
    }

    static void record(String method, String format) {
        if (RECORDER != null) {
            RECORDER.record(1, (Object)new FlightRecorderMessage("SingleConsumerQueue", method, format, null));
        }
    }

    static void record(String method, String format, Object arg1) {
        if (RECORDER != null) {
            RECORDER.record(1, (Object)new FlightRecorderMessage("SingleConsumerQueue", method, format, new Object[]{arg1}));
        }
    }

    static void record(String method, String format, Object arg1, Object arg2) {
        if (RECORDER != null) {
            RECORDER.record(1, (Object)new FlightRecorderMessage("SingleConsumerQueue", method, format, new Object[]{arg1, arg2}));
        }
    }

    static void record(String method, String format, Object arg1, Object arg2, Object arg3) {
        if (RECORDER != null) {
            RECORDER.record(1, (Object)new FlightRecorderMessage("SingleConsumerQueue", method, format, new Object[]{arg1, arg2, arg3}));
        }
    }

    static void record(String method, String format, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (RECORDER != null) {
            RECORDER.record(1, (Object)new FlightRecorderMessage("SingleConsumerQueue", method, format, new Object[]{arg1, arg2, arg3, arg4}));
        }
    }

    static void record(String method, String format, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        if (RECORDER != null) {
            RECORDER.record(1, (Object)new FlightRecorderMessage("SingleConsumerQueue", method, format, new Object[]{arg1, arg2, arg3, arg4, arg5}));
        }
    }
}

