/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers;

import co.paralleluniverse.common.monitoring.FlightRecorder;
import co.paralleluniverse.common.monitoring.FlightRecorderMessage;
import co.paralleluniverse.common.util.Debug;
import co.paralleluniverse.common.util.Exceptions;
import co.paralleluniverse.common.util.SystemProperties;
import co.paralleluniverse.common.util.UtilUnsafe;
import co.paralleluniverse.fibers.Fiber;
import co.paralleluniverse.fibers.FiberTask;
import co.paralleluniverse.fibers.Instrumented;
import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.fibers.Suspendable;
import co.paralleluniverse.fibers.instrument.DontInstrument;
import co.paralleluniverse.strands.SettableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import sun.misc.Unsafe;

@Instrumented
class RunnableFiberTask<V>
implements Runnable,
FiberTask {
    public static final FlightRecorder RECORDER = Debug.isDebug() ? Debug.getGlobalFlightRecorder() : null;
    public static final boolean CAPTURE_UNPARK_STACK = Debug.isDebug() || SystemProperties.isEmptyOrTrue("co.paralleluniverse.fibers.captureUnparkStackTrace");
    private final Executor executor;
    private final Fiber<V> fiber;
    private volatile int state;
    private Object blocker;
    private boolean parkExclusive;
    private Object unparker;
    private StackTraceElement[] unparkStackTrace;
    private final SettableFuture<V> future;
    private static final Unsafe UNSAFE = UtilUnsafe.getUnsafe();
    private static final long stateOffset;

    public RunnableFiberTask(Fiber<V> fiber, Executor executor) {
        this.executor = executor;
        this.fiber = fiber;
        this.state = 0;
        this.future = null;
    }

    @Override
    public Fiber<V> getFiber() {
        return this.fiber;
    }

    @Override
    public boolean isDone() {
        return this.future.isDone();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.future.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Override
    public void run() {
        this.doExec();
    }

    @Override
    public boolean doExec() {
        this.parkExclusive = false;
        this.blocker = null;
        try {
            this.onExec();
            boolean res = this.fiber.exec();
            this.onCompletion(res);
            return res;
        }
        catch (Throwable t) {
            this.onException(t);
            return true;
        }
    }

    @Override
    public Object getBlocker() {
        if (this.state != -1) {
            return null;
        }
        return this.blocker;
    }

    protected void onExec() {
        if (Debug.isDebug()) {
            RunnableFiberTask.record("doExec", "executing %s", this);
        }
    }

    protected void onCompletion(boolean res) {
        if (res && this.future != null) {
            this.future.set(this.fiber.getResult());
        }
    }

    protected void onException(Throwable t) {
        if (this.future == null) {
            throw Exceptions.rethrow(t);
        }
        this.future.setException(t);
    }

    protected void parking(boolean yield) {
    }

    protected void onParked(boolean yield) {
        if (Debug.isDebug()) {
            RunnableFiberTask.record("doExec", "parked " + (yield ? "(yield)" : "(park)") + " %s", this);
        }
        this.fiber.onParked();
    }

    @Override
    public Object getUnparker() {
        return this.unparker;
    }

    @Override
    public StackTraceElement[] getUnparkStackTrace() {
        return this.unparkStackTrace;
    }

    @Override
    public void doPark(boolean yield) {
        if (yield) {
            this.submit();
        } else {
            int newState;
            int _state;
            block5: do {
                _state = this.getState();
                switch (_state) {
                    case -2: {
                        newState = -1;
                        break;
                    }
                    case 0: {
                        newState = 0;
                        break block5;
                    }
                    case 1: {
                        newState = 0;
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Illegal task state (a fiber has no chance to enter `doPark` in anything else than `PARKED` or `RESTART`): " + _state));
                    }
                }
            } while (!this.compareAndSetState(_state, newState));
            if (newState == 0) {
                this.submit();
            }
        }
        this.onParked(yield);
    }

    @DontInstrument
    protected void throwPark(boolean yield) throws SuspendExecution {
        throw yield ? SuspendExecution.YIELD : SuspendExecution.PARK;
    }

    protected boolean park(Object blocker) throws Exception {
        return this.park(blocker, false);
    }

    @Override
    @DontInstrument
    public boolean park(Object blocker, boolean exclusive) throws SuspendExecution {
        int newState;
        int _state;
        do {
            _state = this.getState();
            switch (_state) {
                case 1: {
                    newState = 0;
                    break;
                }
                case 0: {
                    newState = -2;
                    break;
                }
                case -2: 
                case -1: {
                    throw new AssertionError((Object)("Unexpected task state (fiber parking or parked has no chance to to call `park`): " + _state));
                }
                default: {
                    throw new AssertionError((Object)("Unknown task state: " + _state));
                }
            }
        } while (!this.compareAndSetState(_state, newState));
        if (Debug.isDebug()) {
            RunnableFiberTask.record("park", "current: %s - %s -> %s (blocker: %s)", this, _state, newState, blocker);
        }
        if (newState == -2) {
            this.blocker = blocker;
            this.parkExclusive = exclusive;
            this.parking(false);
            this.throwPark(false);
            return true;
        }
        return false;
    }

    @Override
    public boolean unpark() {
        return this.unpark(null);
    }

    @Override
    public boolean unpark(Object unblocker) {
        int newState;
        int _state;
        if (this.fiber.isDone()) {
            return false;
        }
        do {
            _state = this.getState();
            switch (_state) {
                case 0: {
                    newState = 1;
                    break;
                }
                case -1: {
                    if (this.parkExclusive & unblocker != this.blocker & unblocker != EMERGENCY_UNBLOCKER) {
                        return false;
                    }
                    newState = 0;
                    break;
                }
                case -2: {
                    newState = 0;
                    break;
                }
                case 1: {
                    if (Debug.isDebug()) {
                        RunnableFiberTask.record("unpark", "current: %s - %s. return.", this, _state);
                    }
                    return false;
                }
                default: {
                    throw new AssertionError((Object)("Unknown task state: " + _state));
                }
            }
        } while (!this.compareAndSetState(_state, newState));
        if (Debug.isDebug()) {
            RunnableFiberTask.record("unpark", "current: %s - %s -> %s", this, _state, newState);
        }
        if (newState == 0) {
            this.unparker = unblocker;
            if (CAPTURE_UNPARK_STACK) {
                this.unparkStackTrace = Thread.currentThread().getStackTrace();
            }
            if (_state != -2) {
                this.submit();
            }
        }
        return _state == -1 || _state == -2;
    }

    @Override
    public boolean tryUnpark(Object unblocker) {
        boolean res = this.compareAndSetState(-1, 0);
        return res;
    }

    @Override
    @DontInstrument
    public void yield() throws SuspendExecution {
        this.parking(true);
        this.onParked(true);
        this.throwPark(true);
    }

    @Override
    public void submit() {
        this.executor.execute(this);
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public void setState(int state) {
        this.state = state;
    }

    boolean compareAndSetState(int expect, int update) {
        return UNSAFE.compareAndSwapInt(this, stateOffset, expect, update);
    }

    public String toString() {
        return super.toString() + "(Fiber@" + this.fiber.getId() + ')';
    }

    protected boolean isRecording() {
        return RECORDER != null;
    }

    public static void record(String method, String format) {
        if (RECORDER != null) {
            RECORDER.record(1, (Object)new FlightRecorderMessage("RunnableFiberTask", method, format, null));
        }
    }

    public static void record(String method, String format, Object arg1) {
        if (RECORDER != null) {
            RECORDER.record(1, (Object)new FlightRecorderMessage("RunnableFiberTask", method, format, new Object[]{arg1}));
        }
    }

    public static void record(String method, String format, Object arg1, Object arg2) {
        if (RECORDER != null) {
            RECORDER.record(1, (Object)new FlightRecorderMessage("RunnableFiberTask", method, format, new Object[]{arg1, arg2}));
        }
    }

    public static void record(String method, String format, Object arg1, Object arg2, Object arg3) {
        if (RECORDER != null) {
            RECORDER.record(1, (Object)new FlightRecorderMessage("RunnableFiberTask", method, format, new Object[]{arg1, arg2, arg3}));
        }
    }

    public static void record(String method, String format, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (RECORDER != null) {
            RECORDER.record(1, (Object)new FlightRecorderMessage("RunnableFiberTask", method, format, new Object[]{arg1, arg2, arg3, arg4}));
        }
    }

    public static void record(String method, String format, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        if (RECORDER != null) {
            RECORDER.record(1, (Object)new FlightRecorderMessage("RunnableFiberTask", method, format, new Object[]{arg1, arg2, arg3, arg4, arg5}));
        }
    }

    static {
        try {
            stateOffset = UNSAFE.objectFieldOffset(RunnableFiberTask.class.getDeclaredField("state"));
        }
        catch (Exception ex) {
            throw new AssertionError((Object)ex);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    @Suspendable
    @Instrumented(suspendableCallSites={70}, suspendableCallSitesOffsetsAfterInstr={76}, methodStart=70, methodEnd=70, methodOptimized=false)
    public Object get() throws InterruptedException, ExecutionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    @Suspendable
    @Instrumented(suspendableCallSites={76}, suspendableCallSitesOffsetsAfterInstr={148}, methodStart=76, methodEnd=76, methodOptimized=false)
    public Object get(long var1_1, TimeUnit var3_2) throws InterruptedException, ExecutionException, TimeoutException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

