/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public abstract class Tuple<E>
extends AbstractCollection<E>
implements List<E>,
RandomAccess {
    @Override
    public abstract int size();

    @Override
    public abstract E get(int var1);

    @Override
    public final Iterator<E> iterator() {
        return new Iter();
    }

    @Override
    public final ListIterator<E> listIterator() {
        return new ListIter(0);
    }

    @Override
    public final ListIterator<E> listIterator(int index) {
        this.rangeCheck(index);
        return new ListIter(index);
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public final int indexOf(Object o) {
        int size = this.size();
        if (o == null) {
            for (int i = 0; i < size; ++i) {
                if (this.get(i) != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < size; ++i) {
                if (!o.equals(this.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public final int lastIndexOf(Object o) {
        if (o == null) {
            for (int i = this.size() - 1; i >= 0; --i) {
                if (this.get(i) != null) continue;
                return i;
            }
        } else {
            for (int i = this.size() - 1; i >= 0; --i) {
                if (!o.equals(this.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public final List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void rangeCheck(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("" + index);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Tuple)) {
            return false;
        }
        Tuple ot = (Tuple)o;
        int size = this.size();
        if (size != ot.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            E o1 = this.get(i);
            E o2 = ot.get(i);
            if (o1 != null ? o1.equals(o2) : o2 == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            E e = this.get(i);
            hashCode = 31 * hashCode + (e == null ? 0 : e.hashCode());
        }
        return hashCode;
    }

    @Override
    public final boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final E set(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final E remove(int index) {
        throw new UnsupportedOperationException();
    }

    private class ListIter
    extends Iter
    implements ListIterator<E> {
        ListIter(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public E previous() {
            if (this.cursor == 0) {
                throw new NoSuchElementException();
            }
            int i = this.cursor - 1;
            Object previous = Tuple.this.get(i);
            return previous;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }
    }

    private class Iter
    implements Iterator<E> {
        int cursor = 0;

        private Iter() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor != Tuple.this.size();
        }

        @Override
        public E next() {
            if (this.cursor >= Tuple.this.size()) {
                throw new NoSuchElementException();
            }
            int i = this.cursor;
            Object next = Tuple.this.get(i);
            this.cursor = i + 1;
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

