/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common.util;

import java.util.ArrayList;
import java.util.ServiceLoader;

public final class ServiceUtil {
    public static <T> T loadSingletonServiceOrNull(Class<T> type) {
        Object service;
        ServiceLoader<T> loader = ServiceLoader.load(type);
        ArrayList<T> services = new ArrayList<T>();
        for (T service2 : loader) {
            services.add(service2);
        }
        if (services.size() == 1) {
            service = services.iterator().next();
        } else if (services.isEmpty()) {
            service = null;
        } else {
            throw new Error("Several implementations of " + type.getName() + " found: " + services);
        }
        return (T)service;
    }

    public static <T> T loadSingletonService(Class<T> type) {
        T service = ServiceUtil.loadSingletonServiceOrNull(type);
        if (service == null) {
            throw new Error("No implementation of " + type.getName() + " found!");
        }
        return service;
    }

    private ServiceUtil() {
    }
}

