/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common.benchmark;

import co.paralleluniverse.common.benchmark.Striped;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class StripedTimeSeries<V> {
    private final Striped<ThreadRecorder> rs;
    private final boolean autoTimestamp;
    private final long startWallTime;
    private final long startTimestamp;

    public StripedTimeSeries(final int size, boolean autoTimestamp) {
        this.rs = new Striped<ThreadRecorder>(){

            @Override
            protected ThreadRecorder newResource() {
                return new ThreadRecorder(size);
            }
        };
        this.autoTimestamp = autoTimestamp;
        this.startTimestamp = System.nanoTime();
        this.startWallTime = System.currentTimeMillis();
    }

    public void record(V val) {
        if (!this.autoTimestamp) {
            throw new IllegalStateException("Must pass timestamp if autoTimestamp is set");
        }
        this.rs.get().record(System.nanoTime(), val);
    }

    public void record(long timestamp, V val) {
        if (this.autoTimestamp) {
            throw new IllegalStateException("Cannot pass timestamp if autoTimestamp is set");
        }
        this.rs.get().record(timestamp, val);
    }

    public Iterable<Record> getRecords() {
        return new Iterable<Record>(){

            @Override
            public Iterator<Record> iterator() {
                return new Iterator<Record>(){
                    final int n;
                    final ThreadRecorder[] trs;
                    final int[] is;
                    final long[] ts;
                    final Object[] ps;
                    int nextFr;
                    long lastTimestamp;
                    {
                        this.n = StripedTimeSeries.this.rs.size();
                        this.trs = new ThreadRecorder[this.n];
                        this.is = new int[this.n];
                        this.ts = new long[this.n];
                        this.ps = new Object[this.n];
                        this.nextFr = -1;
                        int i = 0;
                        Iterator iterator = StripedTimeSeries.this.rs.iterator();
                        while (iterator.hasNext()) {
                            ThreadRecorder r;
                            this.trs[i] = r = (ThreadRecorder)iterator.next();
                            this.is[i] = -1;
                            this.readNext(i);
                            ++i;
                        }
                        assert (i == this.n);
                        this.nextFr = this.findMin();
                        this.lastTimestamp = -1L;
                    }

                    private void readNext(int index) {
                        ThreadRecorder tr = this.trs[index];
                        int i = this.is[index];
                        if (i < 0 && tr.numOfElements() == 0 || tr.isLast(i)) {
                            this.is[index] = -1;
                            this.ts[index] = Long.MAX_VALUE;
                            this.ps[index] = null;
                        } else {
                            this.is[index] = i = i < 0 ? tr.head : tr.next(i);
                            this.ts[index] = tr.timestamps[i];
                            this.ps[index] = tr.payloads[i];
                        }
                    }

                    private int findMin() {
                        long min = Long.MAX_VALUE;
                        int minIndex = -1;
                        for (int i = 0; i < this.n; ++i) {
                            if (this.ts[i] >= min) continue;
                            min = this.ts[i];
                            minIndex = i;
                        }
                        return minIndex;
                    }

                    private Record createRecord(int index, long lastTimestamp) {
                        long time = StripedTimeSeries.this.autoTimestamp ? StripedTimeSeries.this.startWallTime + (this.ts[index] - StripedTimeSeries.this.startTimestamp) / 1000000L : this.ts[index];
                        return new Record(time, this.ps[index]);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.nextFr >= 0;
                    }

                    @Override
                    public Record next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        Record r = this.createRecord(this.nextFr, this.lastTimestamp);
                        this.readNext(this.nextFr);
                        this.nextFr = this.findMin();
                        return r;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static class ThreadRecorder<V> {
        private final long[] timestamps;
        private final Object[] payloads;
        private long totalRecs;
        private int head;
        private int tail;

        private ThreadRecorder(int size) {
            this.timestamps = new long[size];
            this.payloads = new Object[size];
            this.head = 0;
            this.tail = 0;
            this.totalRecs = 0L;
        }

        public int numOfElements() {
            int n = this.tail - this.head;
            if (this.tail < this.head) {
                n += this.timestamps.length;
            }
            return n;
        }

        public long getTotalRecs() {
            return this.totalRecs;
        }

        private int next(int num) {
            if (++num == this.timestamps.length) {
                num = 0;
            }
            return num;
        }

        private boolean isLast(int i) {
            return this.next(i) == this.tail;
        }

        public void record(long timestamp, V val) {
            ++this.totalRecs;
            this.timestamps[this.tail] = timestamp;
            this.payloads[this.tail] = val;
            this.tail = this.next(this.tail);
            if (this.tail == this.head) {
                this.head = this.next(this.head);
            }
        }
    }

    public static class Record<V> {
        public final long timestamp;
        public final V value;

        private Record(long timestamp, V value) {
            this.timestamp = timestamp;
            this.value = value;
        }
    }
}

