/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.discrepancy;

import cern.colt.list.DoubleArrayList;
import umontreal.ssj.hups.PointSet;
import umontreal.ssj.hups.PointSetIterator;
import umontreal.ssj.util.PrintfFormat;

public abstract class Discrepancy {
    protected static double[] ONES = new double[]{1.0};
    protected double[] gamma;
    protected double[][] Points;
    protected int dim;
    protected int numPoints;
    static final double UNSIX = 0.16666666666666666;
    static final double QUARAN = 0.023809523809523808;
    static final double UNTRENTE = 0.03333333333333333;
    static final double DTIERS = 0.6666666666666666;
    static final double STIERS = 2.3333333333333335;
    static final double QTIERS = 4.666666666666667;

    protected static void setONES(int s) {
        if (s < ONES.length) {
            return;
        }
        ONES = new double[s + 1];
        for (int i = 0; i <= s; ++i) {
            Discrepancy.ONES[i] = 1.0;
        }
    }

    protected void appendGamma(StringBuffer sb, double[] gamma, int s) {
        if (gamma != null) {
            for (int j = 0; j < s; ++j) {
                sb.append("  " + gamma[j]);
            }
        }
    }

    private void initD(double[][] points, int n, int s, double[] gamma) {
        Discrepancy.setONES(s);
        if (gamma == null) {
            this.setGamma(ONES, s);
        } else {
            this.setGamma(gamma, s);
        }
        this.dim = s;
        this.numPoints = n;
        this.Points = points;
    }

    public Discrepancy(double[][] points, int n, int s) {
        this.initD(points, n, s, null);
    }

    public Discrepancy(double[][] points, int n, int s, double[] gamma) {
        this.initD(points, n, s, gamma);
    }

    public Discrepancy(int n, int s, double[] gamma) {
        this.initD(null, n, s, gamma);
    }

    public Discrepancy(PointSet set) {
        this.numPoints = set.getNumPoints();
        this.dim = set.getDimension();
        this.Points = Discrepancy.toArray(set);
        this.initD(this.Points, this.numPoints, this.dim, null);
    }

    public Discrepancy() {
    }

    public double compute() {
        return this.compute(this.Points, this.numPoints, this.dim, this.gamma);
    }

    public double compute(int s) {
        return this.compute(this.Points, this.numPoints, s, this.gamma);
    }

    public double compute(double[][] points, int n, int s, double[] gamma) {
        return -1.0;
    }

    public abstract double compute(double[][] var1, int var2, int var3);

    public double compute(double[][] points) {
        return this.compute(points, points.length, points[0].length, this.gamma);
    }

    public double compute(double[] T, int n) {
        double[][] p = new double[n][1];
        for (int i = 0; i < n; ++i) {
            p[i][0] = T[i];
        }
        return this.compute(p, n, 1);
    }

    public double compute(double[] T) {
        return this.compute(T, T.length, this.gamma[0]);
    }

    public double compute(double[] T, int n, double gamma) {
        return -1.0;
    }

    public double compute(PointSet set, double[] gamma) {
        int n = set.getNumPoints();
        int dim = set.getDimension();
        if (dim > 1) {
            double[][] points = new double[n][dim];
            PointSetIterator it = set.iterator();
            for (int i = 0; i < n; ++i) {
                it.nextPoint(points[i], dim);
            }
            return this.compute(points, n, dim, gamma);
        }
        double[] points = new double[n];
        PointSetIterator it = set.iterator();
        for (int i = 0; i < n; ++i) {
            points[i] = it.nextCoordinate();
            it.resetToNextPoint();
        }
        return this.compute(points, n, gamma[0]);
    }

    public double compute(PointSet set) {
        int dim = set.getDimension();
        Discrepancy.setONES(dim);
        return this.compute(set, ONES);
    }

    public int getNumPoints() {
        return this.numPoints;
    }

    public int getDimension() {
        return this.dim;
    }

    public void setPoints(double[][] points, int n, int s) {
        this.initD(points, n, s, null);
    }

    public void setPoints(double[][] points) {
        this.setPoints(points, points.length, points[0].length);
    }

    public void setGamma(double[] gam, int s) {
        this.gamma = gam;
    }

    public double[] getGamma() {
        return this.gamma;
    }

    public static double[][] toArray(PointSet set) {
        int n = set.getNumPoints();
        int dim = set.getDimension();
        if (dim > 1) {
            double[][] points = new double[n][dim];
            PointSetIterator it = set.iterator();
            for (int i = 0; i < n; ++i) {
                it.nextPoint(points[i], dim);
            }
            return points;
        }
        double[][] po1 = new double[n][1];
        PointSetIterator it = set.iterator();
        for (int i = 0; i < n; ++i) {
            po1[i][0] = it.nextCoordinate();
            it.resetToNextPoint();
        }
        return po1;
    }

    public static DoubleArrayList sort(double[] T, int n) {
        DoubleArrayList sortedU = new DoubleArrayList(T);
        sortedU.sortFromTo(0, n - 1);
        return sortedU;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getName() + ":" + PrintfFormat.NEWLINE);
        sb.append("n = " + this.numPoints + ",   dim = " + this.dim + PrintfFormat.NEWLINE);
        sb.append("gamma = [");
        this.appendGamma(sb, this.gamma, this.dim);
        sb.append(" ]" + PrintfFormat.NEWLINE);
        return sb.toString();
    }

    public String formatPoints() {
        StringBuffer sb = new StringBuffer("Points = [" + PrintfFormat.NEWLINE);
        if (this.Points != null) {
            for (int i = 0; i < this.Points.length; ++i) {
                sb.append(" [ " + this.Points[i][0]);
                for (int j = 1; j < this.Points[0].length; ++j) {
                    sb.append(", " + this.Points[i][j]);
                }
                sb.append(" ]" + PrintfFormat.NEWLINE);
            }
        }
        sb.append(" ]" + PrintfFormat.NEWLINE);
        return sb.toString();
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }
}

