/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation.impl;

import ca.uhn.hl7v2.validation.ValidationContext;
import ca.uhn.hl7v2.validation.ValidationException;
import ca.uhn.hl7v2.validation.impl.DefaultValidation;

public class ValidationContextFactory {
    private static ValidationContext ourContext;
    public static final String CONTEXT_PROPERTY = "ca.uhn.hl7v2.validation.context_class";

    public static synchronized ValidationContext getContext() throws ValidationException {
        if (ourContext == null) {
            String contextClassName = System.getProperty(CONTEXT_PROPERTY);
            if (contextClassName == null) {
                ourContext = new DefaultValidation();
            } else {
                try {
                    Class<?> c = Class.forName(contextClassName);
                    ourContext = (ValidationContext)c.newInstance();
                }
                catch (Exception e) {
                    throw new ValidationException(e);
                }
            }
        }
        return ourContext;
    }
}

