/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.protocol.impl;

import ca.uhn.hl7v2.protocol.AcceptValidator;
import ca.uhn.hl7v2.protocol.ApplicationRouter;
import ca.uhn.hl7v2.protocol.ProcessorContext;
import ca.uhn.hl7v2.protocol.SafeStorage;
import ca.uhn.hl7v2.protocol.TransportLayer;
import java.util.ArrayList;
import java.util.List;

public class ProcessorContextImpl
implements ProcessorContext {
    private final ApplicationRouter myRouter;
    private final TransportLayer myLocallyDrivenTransport;
    private final TransportLayer myRemotelyDrivenTransport;
    private final SafeStorage mySafeStorage;
    private final List myValidators;
    private final List myMetadataFields;

    public ProcessorContextImpl(ApplicationRouter theRouter, TransportLayer theTransport, SafeStorage theStorage) {
        this.myRouter = theRouter;
        this.myRemotelyDrivenTransport = theTransport;
        this.myLocallyDrivenTransport = theTransport;
        this.mySafeStorage = theStorage;
        this.myValidators = new ArrayList(8);
        this.myMetadataFields = new ArrayList(30);
    }

    public ProcessorContextImpl(ApplicationRouter theRouter, TransportLayer theLocallyDrivenTransport, TransportLayer theRemotelyDrivenTransport, SafeStorage theStorage) {
        this.myRouter = theRouter;
        this.myRemotelyDrivenTransport = theRemotelyDrivenTransport;
        this.myLocallyDrivenTransport = theLocallyDrivenTransport;
        this.mySafeStorage = theStorage;
        this.myValidators = new ArrayList(8);
        this.myMetadataFields = new ArrayList(30);
    }

    public ApplicationRouter getRouter() {
        return this.myRouter;
    }

    public TransportLayer getRemotelyDrivenTransportLayer() {
        return this.myRemotelyDrivenTransport;
    }

    public TransportLayer getLocallyDrivenTransportLayer() {
        return this.myLocallyDrivenTransport;
    }

    public AcceptValidator[] getValidators() {
        return this.myValidators.toArray(new AcceptValidator[0]);
    }

    public void addValidator(AcceptValidator theValidator) {
        this.myValidators.add(theValidator);
    }

    public SafeStorage getSafeStorage() {
        return this.mySafeStorage;
    }

    public List getMetadataFields() {
        return this.myMetadataFields;
    }
}

