/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.parser;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.Parser;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomModelClassFactory
implements ModelClassFactory {
    private static final long serialVersionUID = 1L;
    private ModelClassFactory defaultFactory = new DefaultModelClassFactory();
    private Map<String, String[]> customModelClasses;
    private static Log LOG = LogFactory.getLog(CustomModelClassFactory.class);

    public CustomModelClassFactory() {
        this((Map<String, String[]>)null);
    }

    public CustomModelClassFactory(String packageName) {
        this.customModelClasses = new HashMap<String, String[]>();
        if (!packageName.endsWith(".")) {
            packageName = packageName + ".";
        }
        for (String nextVersion : Parser.getValidVersions()) {
            String packageVersion = "v" + nextVersion.replace(".", "");
            this.customModelClasses.put(nextVersion, new String[]{packageName + packageVersion});
        }
    }

    public CustomModelClassFactory(Map<String, String[]> map) {
        this.customModelClasses = map;
    }

    @Override
    public Class<? extends Message> getMessageClass(String name, String version, boolean isExplicit) throws HL7Exception {
        Class<Object> retVal;
        if (!isExplicit) {
            name = Parser.getMessageStructureForEvent(name, version);
        }
        if ((retVal = this.findClass("message", name, version)) == null) {
            retVal = this.defaultFactory.getMessageClass(name, version, isExplicit);
        }
        return retVal;
    }

    @Override
    public Class<? extends Group> getGroupClass(String name, String version) throws HL7Exception {
        Class<Object> retVal = this.findClass("group", name, version);
        if (retVal == null) {
            retVal = this.defaultFactory.getGroupClass(name, version);
        }
        return retVal;
    }

    @Override
    public Class<? extends Segment> getSegmentClass(String name, String version) throws HL7Exception {
        Class<Object> retVal = this.findClass("segment", name, version);
        if (retVal == null) {
            retVal = this.defaultFactory.getSegmentClass(name, version);
        }
        return retVal;
    }

    @Override
    public Class<? extends Type> getTypeClass(String name, String version) throws HL7Exception {
        Class<Object> retVal = this.findClass("datatype", name, version);
        if (retVal == null) {
            retVal = this.defaultFactory.getTypeClass(name, version);
        }
        return retVal;
    }

    protected Class<?> findClass(String subpackage, String name, String version) throws HL7Exception {
        if (!Parser.validVersion(version)) {
            throw new HL7Exception("HL7 version " + version + " is not supported", 203);
        }
        Class<?> classLoaded = null;
        if (this.customModelClasses != null && this.customModelClasses.containsKey(version)) {
            for (String next : this.customModelClasses.get(version)) {
                if (!next.endsWith(".")) {
                    next = next + ".";
                }
                String fullyQualifiedName = next + subpackage + '.' + name;
                try {
                    classLoaded = Class.forName(fullyQualifiedName);
                    LOG.debug((Object)("Found " + fullyQualifiedName + " in custom HL7 model"));
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
        }
        return classLoaded;
    }
}

