/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.VersionLogger;
import ca.uhn.hl7v2.model.GenericGroup;
import ca.uhn.hl7v2.model.GenericSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.parser.EncodingCharacters;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.PipeParser;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGroup
implements Group {
    private ArrayList<String> names;
    private HashMap<String, ArrayList<Structure>> structures;
    private HashMap<String, Boolean> required;
    private HashMap<String, Boolean> repeating;
    private HashMap<String, Class<? extends Structure>> classes;
    private Group parent;
    private Set<String> nonStandardNames;
    private final ModelClassFactory myFactory;

    protected AbstractGroup(Group parent, ModelClassFactory factory) {
        this.parent = parent;
        this.myFactory = factory;
        this.init();
    }

    protected AbstractGroup(ModelClassFactory factory) {
        this.myFactory = factory;
        this.init();
    }

    private void init() {
        this.names = new ArrayList();
        this.structures = new HashMap();
        this.required = new HashMap();
        this.repeating = new HashMap();
        this.classes = new HashMap();
    }

    @Override
    public Structure get(String name) throws HL7Exception {
        return this.get(name, 0);
    }

    @Override
    public Structure get(String name, int rep) throws HL7Exception {
        Structure ret;
        List list = this.structures.get(name);
        if (list == null) {
            throw new HL7Exception(name + " does not exist in the group " + this.getClass().getName(), 207);
        }
        if (rep < list.size()) {
            ret = (Structure)list.get(rep);
        } else if (rep == list.size()) {
            Boolean repeats = this.repeating.get(name);
            if (!repeats.booleanValue() && list.size() > 0) {
                throw new HL7Exception("Can't create repetition #" + rep + " of Structure " + name + " - this Structure is non-repeating", 207);
            }
            Class<? extends Structure> c = this.classes.get(name);
            ret = this.tryToInstantiateStructure(c, name);
            list.add(ret);
        } else {
            throw new HL7Exception("Can't return repetition #" + rep + " of " + name + " - there are only " + list.size() + " repetitions.", 207);
        }
        return ret;
    }

    @Override
    public String addNonstandardSegment(String name) throws HL7Exception {
        String version = this.getMessage().getVersion();
        if (version == null) {
            throw new HL7Exception("Need message version to add segment by name; message.getVersion() returns null");
        }
        Class<? extends Segment> c = this.myFactory.getSegmentClass(name, version);
        if (c == null) {
            c = GenericSegment.class;
        }
        int index = this.getNames().length;
        this.tryToInstantiateStructure(c, name);
        String newName = this.insert(c, false, true, index, name);
        if (this.nonStandardNames == null) {
            this.nonStandardNames = new HashSet<String>();
        }
        this.nonStandardNames.add(newName);
        return newName;
    }

    @Override
    public String addNonstandardSegment(String theName, int theIndex) throws HL7Exception {
        if (this instanceof Message && theIndex == 0) {
            throw new HL7Exception("Can not add nonstandard segment \"" + theName + "\" to start of message.");
        }
        String version = this.getMessage().getVersion();
        if (version == null) {
            throw new HL7Exception("Need message version to add segment by name; message.getVersion() returns null");
        }
        Class<? extends Segment> c = this.myFactory.getSegmentClass(theName, version);
        if (c == null) {
            c = GenericSegment.class;
        }
        this.tryToInstantiateStructure(c, theName);
        String newName = this.insert(c, false, true, theIndex, theName);
        if (this.nonStandardNames == null) {
            this.nonStandardNames = new HashSet<String>();
        }
        this.nonStandardNames.add(newName);
        return newName;
    }

    @Override
    public String[] getNames() {
        String[] retVal = new String[this.names.size()];
        for (int i = 0; i < this.names.size(); ++i) {
            retVal[i] = this.names.get(i);
        }
        return retVal;
    }

    protected String add(Class<? extends Structure> c, boolean required, boolean repeating) throws HL7Exception {
        String name = this.getName(c);
        return this.insert(c, required, repeating, this.names.size(), name);
    }

    protected String add(Class<? extends Structure> c, boolean required, boolean repeating, int index) throws HL7Exception {
        String name = this.getName(c);
        return this.insert(c, required, repeating, index, name);
    }

    private boolean nameExists(String name) {
        boolean exists = false;
        Class<? extends Structure> o = this.classes.get(name);
        if (o != null) {
            exists = true;
        }
        return exists;
    }

    private Structure tryToInstantiateStructure(Class<? extends Structure> c, String name) throws HL7Exception {
        Structure s;
        block9: {
            s = null;
            try {
                Structure o = null;
                if (GenericSegment.class.isAssignableFrom(c)) {
                    String genericName = name;
                    if (genericName.length() > 3) {
                        genericName = genericName.substring(0, 3);
                    }
                    s = new GenericSegment((Group)this, genericName);
                    break block9;
                }
                if (GenericGroup.class.isAssignableFrom(c)) {
                    s = new GenericGroup(this, name, this.myFactory);
                    break block9;
                }
                try {
                    Class[] argClasses = new Class[]{Group.class, ModelClassFactory.class};
                    Object[] argObjects = new Object[]{this, this.myFactory};
                    Constructor<? extends Structure> con = c.getConstructor(argClasses);
                    o = con.newInstance(argObjects);
                }
                catch (NoSuchMethodException nme) {
                    o = c.newInstance();
                }
                if (!(o instanceof Structure)) {
                    throw new HL7Exception("Class " + c.getName() + " does not implement " + "ca.on.uhn.hl7.message.Structure", 207);
                }
                s = o;
            }
            catch (Exception e) {
                if (e instanceof HL7Exception) {
                    throw (HL7Exception)e;
                }
                throw new HL7Exception("Can't instantiate class " + c.getName(), 207, e);
            }
        }
        return s;
    }

    @Override
    public Message getMessage() {
        Group s = this;
        while (!Message.class.isAssignableFrom(s.getClass())) {
            s = s.getParent();
        }
        return (Message)s;
    }

    @Override
    public Group getParent() {
        return this.parent;
    }

    @Override
    public boolean isGroup(String name) throws HL7Exception {
        Class<? extends Structure> clazz = this.classes.get(name);
        if (clazz == null) {
            throw new HL7Exception("The structure " + name + " does not exist in the group " + this.getClass().getName(), 207);
        }
        return Group.class.isAssignableFrom(clazz);
    }

    @Override
    public boolean isRequired(String name) throws HL7Exception {
        Boolean o = this.required.get(name);
        if (o == null) {
            throw new HL7Exception("The structure " + name + " does not exist in the group " + this.getClass().getName(), 207);
        }
        Boolean req = o;
        return req;
    }

    @Override
    public boolean isRepeating(String name) throws HL7Exception {
        Boolean o = this.repeating.get(name);
        if (o == null) {
            throw new HL7Exception("The structure " + name + " does not exist in the group " + this.getClass().getName(), 207);
        }
        Boolean rep = o;
        return rep;
    }

    public int currentReps(String name) throws HL7Exception {
        ArrayList<Structure> list = this.structures.get(name);
        if (list == null) {
            throw new HL7Exception("The structure " + name + " does not exist in the group " + this.getClass().getName(), 207);
        }
        return list.size();
    }

    @Override
    public Structure[] getAll(String name) throws HL7Exception {
        ArrayList<Structure> list = this.structures.get(name);
        if (list == null) {
            throw new HL7Exception("The structure " + name + " does not exist in the group " + this.getClass().getName(), 207);
        }
        Structure[] all = new Structure[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            all[i] = list.get(i);
        }
        return all;
    }

    public Structure removeRepetition(String name, int index) throws HL7Exception {
        ArrayList<Structure> list = this.structures.get(name);
        if (list == null) {
            throw new HL7Exception("The structure " + name + " does not exist in the group " + this.getClass().getName(), 207);
        }
        if (list.size() == 0) {
            throw new HL7Exception("Invalid index: " + index + ", structure " + name + " has no repetitions", 207);
        }
        if (list.size() <= index) {
            throw new HL7Exception("Invalid index: " + index + ", structure " + name + " must be between 0 and " + (list.size() - 1), 207);
        }
        return list.remove(index);
    }

    protected void insertRepetition(String name, Structure structure, int index) throws HL7Exception {
        if (structure == null) {
            throw new NullPointerException("Structure may not be null");
        }
        if (structure.getMessage() != this.getMessage()) {
            throw new HL7Exception("Structure does not belong to this message", 207);
        }
        ArrayList<Structure> list = this.structures.get(name);
        if (list == null) {
            throw new HL7Exception("The structure " + name + " does not exist in the group " + this.getClass().getName(), 207);
        }
        if (list.size() < index) {
            throw new HL7Exception("Invalid index: " + index + ", structure " + name + " must be between 0 and " + list.size(), 207);
        }
        list.add(index, structure);
    }

    public Structure insertRepetition(String name, int index) throws HL7Exception {
        if (name == null || name.length() == 0) {
            throw new NullPointerException("Name may not be null/empty");
        }
        Class<? extends Structure> structureClass = this.classes.get(name);
        if (structureClass == null) {
            throw new HL7Exception("Group " + this.getClass().getName() + " has no structure named " + name + ": Valid names: " + this.classes.keySet(), 207);
        }
        Structure rep = this.tryToInstantiateStructure(structureClass, name);
        this.insertRepetition(name, rep, index);
        return rep;
    }

    @Override
    public Class<? extends Structure> getClass(String name) {
        return this.classes.get(name);
    }

    @Override
    public String getName() {
        return this.getName(this.getClass());
    }

    private String getName(Class<? extends Structure> c) {
        String messageName;
        String fullName = c.getName();
        int dotLoc = fullName.lastIndexOf(46);
        String name = fullName.substring(dotLoc + 1, fullName.length());
        if (Group.class.isAssignableFrom(c) && !Message.class.isAssignableFrom(c) && name.startsWith(messageName = this.getMessage().getName()) && name.length() > messageName.length()) {
            name = name.substring(messageName.length() + 1);
        }
        return name;
    }

    private String insert(Class<? extends Structure> c, boolean required, boolean repeating, int index, String name) throws HL7Exception {
        if (this.nameExists(name)) {
            int version = 2;
            String newName = name;
            while (this.nameExists(newName)) {
                newName = name + version++;
            }
            name = newName;
        }
        if (index > this.names.size()) {
            throw new HL7Exception("Invalid index " + index + " - Should be <= " + this.names.size());
        }
        this.names.add(index, name);
        this.required.put(name, new Boolean(required));
        this.repeating.put(name, new Boolean(repeating));
        this.classes.put(name, c);
        this.structures.put(name, new ArrayList());
        return name;
    }

    public void clear() {
        for (ArrayList<Structure> next : this.structures.values()) {
            if (next == null) continue;
            next.clear();
        }
    }

    public final ModelClassFactory getModelClassFactory() {
        return this.myFactory;
    }

    void appendStructureDescription(StringBuilder theStringBuilder, int theIndent, boolean theOptional, boolean theRepeating, boolean theAddStartName, boolean theAddEndName) throws HL7Exception {
        String lineSeparator = System.getProperty("line.separator");
        if (theAddStartName) {
            this.indent(theStringBuilder, theIndent);
            theStringBuilder.append(this.getName()).append(" (start)").append(lineSeparator);
        }
        if (theOptional || theRepeating) {
            this.indent(theStringBuilder, theIndent);
            if (theOptional) {
                theStringBuilder.append("[");
            }
            if (theRepeating) {
                theStringBuilder.append("{");
            }
            theStringBuilder.append(lineSeparator);
        }
        for (String nextName : this.getNames()) {
            Class<? extends Structure> nextClass = this.classes.get(nextName);
            boolean nextOptional = this.required.get(nextName) == false;
            boolean nextRepeating = this.repeating.get(nextName);
            if (AbstractGroup.class.isAssignableFrom(nextClass)) {
                Structure[] nextChildren = this.getAll(nextName);
                for (int i = 0; i < nextChildren.length; ++i) {
                    Structure structure = nextChildren[i];
                    boolean addStartName = i == 0;
                    boolean addEndName = i == nextChildren.length - 1;
                    ((AbstractGroup)structure).appendStructureDescription(theStringBuilder, theIndent + 3, nextOptional, nextRepeating, addStartName, addEndName);
                }
                if (nextChildren.length != 0) continue;
                Structure structure = this.tryToInstantiateStructure(nextClass, nextName);
                ((AbstractGroup)structure).appendStructureDescription(theStringBuilder, theIndent + 3, nextOptional, nextRepeating, true, true);
                continue;
            }
            if (!Segment.class.isAssignableFrom(nextClass)) continue;
            int currentIndent = theStringBuilder.length();
            StringBuilder structurePrefix = new StringBuilder();
            this.indent(structurePrefix, theIndent + 3);
            if (nextOptional) {
                structurePrefix.append("[ ");
            }
            if (nextRepeating) {
                structurePrefix.append("{ ");
            }
            structurePrefix.append(nextName);
            if (nextRepeating) {
                structurePrefix.append(" }");
            }
            if (nextOptional) {
                structurePrefix.append(" ]");
            }
            if (this.nonStandardNames != null && this.nonStandardNames.contains(nextName)) {
                structurePrefix.append(" (non-standard)");
            }
            structurePrefix.append(" - ");
            currentIndent = theStringBuilder.length() - currentIndent;
            ArrayList<Structure> nextStructureList = this.structures.get(nextName);
            theStringBuilder.append((CharSequence)structurePrefix);
            if (nextStructureList == null || nextStructureList.isEmpty()) {
                theStringBuilder.append("Not populated");
                theStringBuilder.append(lineSeparator);
                continue;
            }
            for (int i = 0; i < nextStructureList.size(); ++i) {
                if (i > 0) {
                    this.indent(theStringBuilder, currentIndent + structurePrefix.length());
                }
                Segment nextSegment = (Segment)nextStructureList.get(i);
                theStringBuilder.append(new PipeParser().doEncode(nextSegment, EncodingCharacters.getInstance(this.getMessage())));
                theStringBuilder.append(lineSeparator);
            }
        }
        if (theOptional || theRepeating) {
            this.indent(theStringBuilder, theIndent);
            if (theRepeating) {
                theStringBuilder.append("}");
            }
            if (theOptional) {
                theStringBuilder.append("]");
            }
            theStringBuilder.append(lineSeparator);
        }
        if (theAddEndName) {
            this.indent(theStringBuilder, theIndent);
            theStringBuilder.append(this.getName()).append(" (end)").append(lineSeparator);
        }
    }

    private void indent(StringBuilder theStringBuilder, int theIndent) {
        for (int i = 0; i < theIndent; ++i) {
            theStringBuilder.append(' ');
        }
    }

    static {
        VersionLogger.init();
    }
}

