/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.conf.store;

import ca.uhn.hl7v2.conf.store.ProfileStore;
import ca.uhn.log.HapiLog;
import ca.uhn.log.HapiLogFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class FileProfileStore
implements ProfileStore {
    private File root;
    private static final HapiLog log = HapiLogFactory.getHapiLog(FileProfileStore.class);

    public FileProfileStore(String file) {
        this.root = new File(file);
        if (!this.root.isDirectory() && !this.root.mkdirs()) {
            throw new IllegalArgumentException(file + " is not a directory");
        }
    }

    public String getProfile(String ID2) throws IOException {
        String profile = null;
        File source = new File(this.getFileName(ID2));
        if (source.isFile()) {
            BufferedReader in = new BufferedReader(new FileReader(source));
            char[] buf = new char[(int)source.length()];
            int check = in.read(buf, 0, buf.length);
            in.close();
            if (check != buf.length) {
                throw new IOException("Only read " + check + " of " + buf.length + " bytes of file " + source.getAbsolutePath());
            }
            profile = new String(buf);
        }
        log.info("Got profile " + ID2 + ": \r\n" + profile);
        return profile;
    }

    public void persistProfile(String ID2, String profile) throws IOException {
        File dest = new File(this.getFileName(ID2));
        BufferedWriter out = new BufferedWriter(new FileWriter(dest));
        out.write(profile);
        out.flush();
        out.close();
    }

    private String getFileName(String ID2) {
        return this.root.getAbsolutePath() + "/" + ID2 + ".xml";
    }
}

