/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.app;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.app.Connection;
import ca.uhn.hl7v2.app.MessageReceipt;
import ca.uhn.hl7v2.llp.HL7Reader;
import ca.uhn.hl7v2.llp.HL7Writer;
import ca.uhn.hl7v2.llp.LLPException;
import ca.uhn.hl7v2.llp.LowerLayerProtocol;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.util.MessageIDGenerator;
import ca.uhn.hl7v2.util.Terser;
import ca.uhn.log.HapiLog;
import ca.uhn.log.HapiLogFactory;
import java.io.IOException;
import java.net.Socket;

public class Initiator {
    private static final HapiLog log = HapiLogFactory.getHapiLog(Initiator.class);
    private HL7Reader in;
    private HL7Writer out;
    private Connection conn;
    private int timeoutMillis = 10000;

    protected Initiator(Connection conn) throws LLPException {
        this.conn = conn;
        String timeout = System.getProperty("ca.uhn.hl7v2.app.initiator.timeout");
        if (timeout != null) {
            try {
                this.timeoutMillis = Integer.parseInt(timeout);
                log.debug("Setting Initiator timeout to " + timeout + " ms");
            }
            catch (NumberFormatException e) {
                log.warn(timeout + " is not a valid integer - Initiator is using default timeout");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message sendAndReceive(Message out) throws HL7Exception, LLPException, IOException {
        HapiLog rawOutbound = HapiLogFactory.getHapiLog("ca.uhn.hl7v2.raw.outbound");
        HapiLog rawInbound = HapiLogFactory.getHapiLog("ca.uhn.hl7v2.raw.inbound");
        if (out == null) {
            throw new HL7Exception("Can't encode null message", 101);
        }
        Terser t = new Terser(out);
        String messID = t.get("/MSH-10");
        if (messID == null || messID.length() == 0) {
            throw new HL7Exception("MSH segment missing required field Control ID (MSH-10)", 101);
        }
        MessageReceipt mr = this.conn.reserveResponse(messID);
        String outbound = this.conn.getParser().encode(out);
        log.info("Initiator sending message: " + outbound);
        rawOutbound.info(outbound);
        try {
            this.conn.getSendWriter().writeMessage(outbound);
        }
        catch (IOException e) {
            this.conn.close();
            throw e;
        }
        boolean done = false;
        Message response = null;
        long startTime = System.currentTimeMillis();
        while (!done) {
            MessageReceipt messageReceipt = mr;
            synchronized (messageReceipt) {
                try {
                    mr.wait(500L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (mr.getMessage() != null) {
                    String inbound = mr.getMessage();
                    log.info("Initiator received message: " + inbound);
                    rawInbound.info(inbound);
                    response = this.conn.getParser().parse(inbound);
                    log.debug("response parsed");
                    done = true;
                }
                if (System.currentTimeMillis() > startTime + (long)this.timeoutMillis) {
                    throw new HL7Exception("Timeout waiting for response to message with control ID '" + messID);
                }
            }
        }
        return response;
    }

    public void setTimeoutMillis(int timeout) {
        this.timeoutMillis = timeout;
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage: ca.uhn.hl7v2.app.Initiator host port");
        }
        try {
            String host = args[0];
            int port = Integer.parseInt(args[1]);
            final PipeParser parser = new PipeParser();
            LowerLayerProtocol llp = LowerLayerProtocol.makeLLP();
            Connection connection = new Connection(parser, llp, new Socket(host, port));
            final Initiator initiator = connection.getInitiator();
            String outText = "MSH|^~\\&|||||||ACK^^ACK|||R|2.4|\rMSA|AA";
            for (int i = 0; i < 1000; ++i) {
                Thread sender = new Thread(new Runnable(){

                    public void run() {
                        try {
                            String ID2 = MessageIDGenerator.getInstance().getNewID();
                            Message out = parser.parse("MSH|^~\\&|||||||ACK^^ACK|||R|2.4|\rMSA|AA");
                            Terser tOut = new Terser(out);
                            tOut.set("/MSH-10", ID2);
                            Message in = initiator.sendAndReceive(out);
                            Terser tIn = new Terser(in);
                            String ackID = tIn.get("/MSA-2");
                            if (!ID2.equals(ackID)) {
                                throw new RuntimeException("Ack ID for message " + ID2 + " is " + ackID);
                            }
                            System.out.println("OK - ack ID matches");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
                sender.start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

