/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.app;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.app.Connection;
import ca.uhn.hl7v2.llp.LLPException;
import ca.uhn.hl7v2.llp.LowerLayerProtocol;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.log.HapiLog;
import ca.uhn.log.HapiLogFactory;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionHub {
    public static final String MAX_CONCURRENT_TARGETS = ConnectionHub.class.getName() + ".maxSize";
    private static final HapiLog log = HapiLogFactory.getHapiLog(ConnectionHub.class);
    private static ConnectionHub instance = null;
    private final Map<String, Connection> connections = new HashMap<String, Connection>(20);
    private final Map<String, Socket> sockets = new HashMap<String, Socket>(20);
    private final Map<Integer, Integer> numRefs = new HashMap<Integer, Integer>(20);
    private final Map<String, String> connectionMutexes = Collections.synchronizedMap(new LinkedHashMap<String, String>(5, 0.75f, true){
        private static final long serialVersionUID = 1L;
        final int maxSize;
        {
            this.maxSize = new Integer(System.getProperty(MAX_CONCURRENT_TARGETS, "1000"));
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, String> eldest) {
            return this.size() > this.maxSize;
        }
    });

    private ConnectionHub() {
    }

    public static synchronized ConnectionHub getInstance() {
        if (instance == null) {
            instance = new ConnectionHub();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection attach(String host, int port, Parser parser, Class<? extends LowerLayerProtocol> llpClass) throws HL7Exception {
        Connection conn;
        String connectionMutex = host + ":" + port;
        Map<String, String> map = this.connectionMutexes;
        synchronized (map) {
            if (this.connectionMutexes.containsKey(connectionMutex)) {
                connectionMutex = this.connectionMutexes.get(connectionMutex);
            } else {
                this.connectionMutexes.put(connectionMutex, connectionMutex);
            }
        }
        String string = connectionMutex;
        synchronized (string) {
            conn = this.getExisting(host, port, parser.getClass(), llpClass);
            if (conn != null && !conn.isOpen()) {
                if (log.isDebugEnabled()) {
                    log.debug("Discarding connection which appears to be closed. Remote addr: " + conn.getRemoteAddress());
                }
                this.close(conn);
                conn = null;
            }
            if (conn == null) {
                try {
                    LowerLayerProtocol llp = llpClass.newInstance();
                    conn = this.connect(host, port, parser, llp);
                }
                catch (ClassCastException e) {
                    throw new HL7Exception("ClassCastException - need a LowerLayerProtocol class to get an Inititator", 207, e);
                }
                catch (Exception e) {
                    throw new HL7Exception("Can't connect to " + host + " port " + port + ": " + e.getClass().getName() + ": " + e.getMessage(), 207, e);
                }
            }
            this.incrementRefs(conn);
        }
        return conn;
    }

    private Connection getExisting(String host, int port, Class parserClass, Class llpClass) {
        Connection existing = null;
        Connection o = this.connections.get(ConnectionHub.makeHashKey(host, port, parserClass, llpClass));
        if (o != null) {
            existing = o;
        }
        return existing;
    }

    private Connection connect(String host, int port, Parser parser, LowerLayerProtocol llp) throws UnknownHostException, IOException, LLPException {
        Socket s = new Socket(host, port);
        Connection i = new Connection(parser, llp, s);
        this.connections.put(ConnectionHub.makeHashKey(host, port, parser.getClass(), llp.getClass()), i);
        this.sockets.put(ConnectionHub.makeHashKey(host, port, parser.getClass(), llp.getClass()), s);
        return i;
    }

    public void detach(Connection c) {
        int refs = this.decrementRefs(c);
        if (refs == 0) {
            this.close(c);
        }
    }

    public void discard(Connection c) {
        this.close(c);
    }

    private void close(Connection c) {
        c.close();
        Iterator<String> keys = this.connections.keySet().iterator();
        boolean removed = false;
        while (keys.hasNext() && !removed) {
            String key = keys.next();
            Connection val = this.connections.get(key);
            if (((Object)val).hashCode() != c.hashCode()) continue;
            this.connections.remove(key);
            this.numRefs.remove(new Integer(c.hashCode()));
            removed = true;
        }
    }

    private int incrementRefs(Connection c) {
        return this.updateRefs(c, 1);
    }

    private int decrementRefs(Connection c) {
        return this.updateRefs(c, -1);
    }

    private synchronized int updateRefs(Connection c, int change) {
        Integer hashCode = new Integer(c.hashCode());
        Integer o = this.numRefs.get(hashCode);
        int existingRefs = 0;
        if (o != null) {
            existingRefs = o;
        }
        Integer newRefs = new Integer(existingRefs + change);
        this.numRefs.put(hashCode, newRefs);
        return newRefs;
    }

    private static String makeHashKey(String IP, int port, Class parserClass, Class llpClass) {
        StringBuffer key = new StringBuffer();
        key.append(IP);
        key.append(":");
        key.append(port);
        key.append(":");
        key.append(parserClass.getName());
        key.append(":");
        key.append(llpClass.getName());
        return key.toString();
    }
}

