/*
 * Decompiled with CFR 0.152.
 */
package org.browsermob.proxy.jetty.html;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.browsermob.proxy.jetty.html.Frame;
import org.browsermob.proxy.jetty.html.Page;

public class FrameSet
extends Page {
    Frame[][] frames = null;
    String colSpec = null;
    String rowSpec = null;
    int cols;
    int rows;
    String border = "";
    Vector frameNames = null;
    Hashtable frameMap = null;

    public FrameSet(String title, String colSpec, String rowSpec) {
        super(title);
        this.colSpec = colSpec;
        this.rowSpec = rowSpec;
        this.cols = 1;
        this.rows = 1;
        int i = -1;
        while (colSpec != null && (i = colSpec.indexOf(",", i + 1)) >= 0) {
            ++this.cols;
        }
        i = -1;
        while (rowSpec != null && (i = rowSpec.indexOf(",", i + 1)) >= 0) {
            ++this.rows;
        }
        this.frames = new Frame[this.cols][this.rows];
        for (int c = 0; c < this.cols; ++c) {
            for (int r = 0; r < this.rows; ++r) {
                this.frames[c][r] = new Frame();
            }
        }
    }

    public Frame frame(int col, int row) {
        return this.frames[col][row];
    }

    public FrameSet border(boolean threeD, int width, String color) {
        this.border = " frameborder=\"" + (threeD ? "yes" : "no") + "\"";
        if (width >= 0) {
            this.border = this.border + " border=\"" + width + "\"";
        }
        if (color != null) {
            this.border = this.border + " bordercolor=\"" + color + "\"";
        }
        return this;
    }

    public Enumeration namedFrames() {
        if (this.frameNames == null) {
            return new Vector().elements();
        }
        return this.frameNames.elements();
    }

    public Frame frame(String name) {
        if (this.frameMap == null) {
            return null;
        }
        return (Frame)this.frameMap.get(name);
    }

    public Frame nameFrame(String name, int col, int row) {
        Frame frame;
        if (this.frameMap == null) {
            this.frameMap = new Hashtable(10);
            this.frameNames = new Vector(10);
        }
        if ((frame = this.frames[col][row]) == null) {
            Frame frame2 = new Frame();
            this.frames[col][row] = frame2;
            frame = frame2;
        }
        if (this.frameMap.get(name) == null) {
            this.frameNames.addElement(name);
        }
        this.frameMap.put(name, frame);
        frame.name(name);
        return frame;
    }

    @Override
    public void write(Writer out) throws IOException {
        this.writeHtmlHead(out);
        out.write("<frameset " + this.border);
        if (this.colSpec != null) {
            out.write(" cols=\"" + this.colSpec + "\"");
        }
        if (this.rowSpec != null) {
            out.write(" rows=\"" + this.rowSpec + "\"");
        }
        out.write(">");
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.cols; ++c) {
                this.frames[c][r].write(out);
            }
        }
        out.write("<noframes>");
        this.writeElements(out);
        out.write("</noframes>");
        out.write("</frameset>");
        out.write("</html>");
    }
}

