/*
 * Decompiled with CFR 0.152.
 */
package cz.mallat.uasparser;

import cz.mallat.uasparser.BrowserEntry;
import cz.mallat.uasparser.OsEntry;
import cz.mallat.uasparser.RobotEntry;
import cz.mallat.uasparser.UserAgentInfo;
import cz.mallat.uasparser.fileparser.Entry;
import cz.mallat.uasparser.fileparser.PHPFileParser;
import cz.mallat.uasparser.fileparser.Section;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UASparser {
    static final String INFO_URL = "http://user-agent-string.info";
    private Map<String, RobotEntry> robotsMap;
    private Map<Long, OsEntry> osMap;
    private Map<Long, BrowserEntry> browserMap;
    private Map<Long, String> browserTypeMap;
    private Map<String, Long> browserRegMap;
    private Map<Long, Long> browserOsMap;
    private Map<String, Long> osRegMap;

    public UASparser(String localDefinitionFilename) throws IOException {
        this.loadDataFromFile(new File(localDefinitionFilename));
    }

    public UASparser(InputStream inputStreamToDefinitionFile) throws IOException {
        this.loadDataFromFile(inputStreamToDefinitionFile);
    }

    protected UASparser() {
    }

    protected void checkDataMaps() throws IOException {
    }

    public UserAgentInfo parse(String useragent) throws IOException {
        boolean osFound;
        UserAgentInfo retObj = new UserAgentInfo();
        if (useragent == null) {
            return retObj;
        }
        useragent = useragent.trim();
        this.checkDataMaps();
        if (!this.processRobot(useragent, retObj) && !(osFound = this.processBrowserRegex(useragent, retObj))) {
            this.processOsRegex(useragent, retObj);
        }
        return retObj;
    }

    private void processOsRegex(String useragent, UserAgentInfo retObj) {
        for (Map.Entry<String, Long> entry : this.osRegMap.entrySet()) {
            Pattern pattern = Pattern.compile(entry.getKey(), 34);
            Matcher matcher = pattern.matcher(useragent);
            if (!matcher.find()) continue;
            Long idOs = entry.getValue();
            OsEntry os = this.osMap.get(idOs);
            if (os == null) break;
            os.copyTo(retObj);
            break;
        }
    }

    private boolean processBrowserRegex(String useragent, UserAgentInfo retObj) {
        boolean osFound = false;
        for (Map.Entry<String, Long> entry : this.browserRegMap.entrySet()) {
            Long idOs;
            Pattern pattern = Pattern.compile(entry.getKey(), 34);
            Matcher matcher = pattern.matcher(useragent);
            if (!matcher.find()) continue;
            Long idBrowser = entry.getValue();
            this.copyType(retObj, idBrowser);
            BrowserEntry be = this.browserMap.get(idBrowser);
            if (be != null) {
                String browserVersionInfo = null;
                if (matcher.groupCount() > 0) {
                    browserVersionInfo = matcher.group(1);
                }
                be.copyTo(retObj, browserVersionInfo);
            }
            if ((idOs = this.browserOsMap.get(idBrowser)) == null) break;
            osFound = true;
            OsEntry os = this.osMap.get(idOs);
            if (os == null) break;
            os.copyTo(retObj);
            break;
        }
        return osFound;
    }

    private void copyType(UserAgentInfo retObj, Long idBrowser) {
        String typeString;
        Long type;
        BrowserEntry be = this.browserMap.get(idBrowser);
        if (be != null && (type = be.getType()) != null && (typeString = this.browserTypeMap.get(type)) != null) {
            retObj.setTyp(typeString);
        }
    }

    private boolean processRobot(String useragent, UserAgentInfo retObj) {
        if (this.robotsMap.containsKey(useragent)) {
            OsEntry os;
            retObj.setTyp("Robot");
            RobotEntry robotEntry = this.robotsMap.get(useragent);
            robotEntry.copyTo(retObj);
            if (robotEntry.getOsId() != null && (os = this.osMap.get(robotEntry.getOsId())) != null) {
                os.copyTo(retObj);
            }
            return true;
        }
        return false;
    }

    protected void loadDataFromFile(File definitionFile) throws IOException {
        PHPFileParser fp = new PHPFileParser(definitionFile);
        this.createInternalDataStructre(fp.getSections());
    }

    protected void loadDataFromFile(InputStream is) throws IOException {
        PHPFileParser fp = new PHPFileParser(is);
        this.createInternalDataStructre(fp.getSections());
    }

    protected void createInternalDataStructre(List<Section> sectionList) {
        for (Section sec : sectionList) {
            Iterator<String> it;
            if ("robots".equals(sec.getName())) {
                HashMap<String, RobotEntry> robotsMapTmp = new HashMap<String, RobotEntry>();
                for (Entry en : sec.getEntries()) {
                    RobotEntry re = new RobotEntry(en.getData());
                    robotsMapTmp.put(re.getUserAgentString(), re);
                }
                this.robotsMap = robotsMapTmp;
                continue;
            }
            if ("os".equals(sec.getName())) {
                HashMap<Long, OsEntry> osMapTmp = new HashMap<Long, OsEntry>();
                for (Entry en : sec.getEntries()) {
                    OsEntry oe = new OsEntry(en.getData());
                    osMapTmp.put(Long.parseLong(en.getKey()), oe);
                }
                this.osMap = osMapTmp;
                continue;
            }
            if ("browser".equals(sec.getName())) {
                HashMap<Long, BrowserEntry> browserMapTmp = new HashMap<Long, BrowserEntry>();
                for (Entry en : sec.getEntries()) {
                    BrowserEntry be = new BrowserEntry(en.getData());
                    browserMapTmp.put(Long.parseLong(en.getKey()), be);
                }
                this.browserMap = browserMapTmp;
                continue;
            }
            if ("browser_type".equals(sec.getName())) {
                HashMap<Long, String> browserTypeMapTmp = new HashMap<Long, String>();
                for (Entry en : sec.getEntries()) {
                    browserTypeMapTmp.put(Long.parseLong(en.getKey()), en.getData().iterator().next());
                }
                this.browserTypeMap = browserTypeMapTmp;
                continue;
            }
            if ("browser_reg".equals(sec.getName())) {
                LinkedHashMap<String, Long> browserRegMapTmp = new LinkedHashMap<String, Long>();
                for (Entry en : sec.getEntries()) {
                    it = en.getData().iterator();
                    browserRegMapTmp.put(this.convertPerlToJavaRegex(it.next()), Long.parseLong(it.next()));
                }
                this.browserRegMap = browserRegMapTmp;
                continue;
            }
            if ("browser_os".equals(sec.getName())) {
                HashMap<Long, Long> browserOsMapTmp = new HashMap<Long, Long>();
                for (Entry en : sec.getEntries()) {
                    browserOsMapTmp.put(Long.parseLong(en.getKey()), Long.parseLong(en.getData().iterator().next()));
                }
                this.browserOsMap = browserOsMapTmp;
                continue;
            }
            if (!"os_reg".equals(sec.getName())) continue;
            LinkedHashMap<String, Long> osRegMapTmp = new LinkedHashMap<String, Long>();
            for (Entry en : sec.getEntries()) {
                it = en.getData().iterator();
                osRegMapTmp.put(this.convertPerlToJavaRegex(it.next()), Long.parseLong(it.next()));
            }
            this.osRegMap = osRegMapTmp;
        }
    }

    private String convertPerlToJavaRegex(String regex) {
        regex = regex.substring(1);
        int lastIndex = regex.lastIndexOf(47);
        regex = regex.substring(0, lastIndex);
        return regex;
    }
}

