/*
 * Decompiled with CFR 0.152.
 */
package org.sharengo.wikitty.jms;

import java.util.Date;
import java.util.Enumeration;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.XATopicSession;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sharengo.wikitty.WikittyTransaction;

public class WikittyJMSUtil {
    private static Log log = LogFactory.getLog(WikittyJMSUtil.class);
    public static final String TOPIC_CONNECTION_FACTORY = "TopicConnectionFactory";
    public static final String TOPIC_WIKITTY_STORAGE = "WikittyStorageTopic";
    public static final String TOPIC_EXTENSION_STORAGE = "WikittyExtensionStorageTopic";
    public static final String ACTION_STORE = "store";
    public static final String ACTION_DELETE = "delete";
    public static final String ACTION_CLEAR = "clear";
    public static final String PARAM_WIKITTIES = "wikitties";
    public static final String PARAM_DISABLE_AUTO_VERSION_INCREMENT = "disableAutoVersionIncrement";
    public static final String PARAM_IDS = "ids";
    public static final String PARAM_ACTION = "action";
    public static final String PARAM_EXTENSIONS = "extensions";
    public static final String JNDI_PROVIDER_URL = "java.naming.provider.url";

    public static void addXAResource(WikittyTransaction transaction, XATopicSession topicSession) throws Exception {
        XAResource xAResource = topicSession.getXAResource();
        TransactionManager transactionManager = transaction.getTransactionManager();
        transactionManager.getTransaction().enlistResource(xAResource);
    }

    public static void logMessageHeaders(Log logger, Message message) {
        if (message == null) {
            logger.warn((Object)"message is null");
            return;
        }
        try {
            Destination dest = message.getJMSDestination();
            logger.debug((Object)("JMSDestination: " + dest));
            int delMode = message.getJMSDeliveryMode();
            if (delMode == 1) {
                logger.debug((Object)"JMSDeliveryMode: non-persistent");
            } else if (delMode == 2) {
                logger.debug((Object)"JMSDeliveryMode: persistent");
            } else {
                logger.error((Object)"JMSDeliveryMode: neither persistent nor non-persistent");
            }
            long expiration = message.getJMSExpiration();
            if (expiration != 0L) {
                Date expTime = new Date(expiration);
                logger.debug((Object)("JMSExpiration: " + expTime));
            } else {
                logger.debug((Object)("JMSExpiration: " + expiration));
            }
            int priority = message.getJMSPriority();
            logger.debug((Object)("JMSPriority: " + priority));
            String msgID = message.getJMSMessageID();
            logger.debug((Object)("JMSMessageID: " + msgID));
            long timestamp = message.getJMSTimestamp();
            if (timestamp != 0L) {
                Date timestampTime = new Date(timestamp);
                logger.debug((Object)("JMSTimestamp: " + timestampTime));
            } else {
                logger.debug((Object)("JMSTimestamp: " + timestamp));
            }
            String correlID = message.getJMSCorrelationID();
            logger.debug((Object)("JMSCorrelationID: " + correlID));
            Destination replyTo = message.getJMSReplyTo();
            logger.debug((Object)("JMSReplyTo: " + replyTo));
            boolean redelivered = message.getJMSRedelivered();
            logger.debug((Object)("JMSRedelivered: " + redelivered));
            String type = message.getJMSType();
            logger.debug((Object)("JMSType: " + type));
            Enumeration e = message.getPropertyNames();
            while (e.hasMoreElements()) {
                String propertyName = (String)e.nextElement();
                logger.debug((Object)("Client property " + propertyName + ": " + message.getObjectProperty(propertyName)));
            }
        }
        catch (JMSException e) {
            logger.error((Object)"JMSException occurred: ", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"Exception occurred: ", (Throwable)e);
        }
    }
}

