/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.publication;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.ArgumentsParserException;
import org.nuiton.util.ObjectUtil;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.WikittyConfig;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceFactory;
import org.nuiton.wikitty.entities.WikittyLabelAbstract;
import org.nuiton.wikitty.entities.WikittyTreeNodeAbstract;
import org.nuiton.wikitty.entities.WikittyUserAbstract;
import org.nuiton.wikitty.publication.ActionError;
import org.nuiton.wikitty.publication.WikittyPublicationAction;
import org.nuiton.wikitty.publication.entities.WikittyPubDataAbstract;
import org.nuiton.wikitty.publication.entities.WikittyPubTextAbstract;

public class WikittyPublicationContext {
    private static Log log = LogFactory.getLog(WikittyPublicationContext.class);
    public static final String CONFIG_FILE = "wikitty.publication.config.pattern";
    public static final String ACTION_PREFIX = "wikitty.publication.action";
    protected static final Map<String, WikittyService> services = new HashMap();
    protected static final Map<String, WikittyPublicationAction> actions = new HashMap();
    protected ApplicationConfig appConfig;
    protected HttpServletRequest req;
    protected HttpServletResponse resp;
    protected String wsContext = null;
    protected String actionName = null;
    protected String path = "";
    protected List<String> mandatoryArguments = new ArrayList();
    protected Map<String, String> arguments = new HashMap();
    protected Map<String, byte[]> argumentFiles = new HashMap();
    protected WikittyProxy proxy = null;
    protected String contentType = "text/html";

    public WikittyPublicationContext(ApplicationConfig appConfig) {
        this.appConfig = appConfig;
        for (String key : appConfig.getFlatOptions().stringPropertyNames()) {
            if (!key.startsWith(ACTION_PREFIX)) continue;
            String action = key.substring(ACTION_PREFIX.length() + 1);
            this.getAction(action);
        }
    }

    protected void addRequiredExtension(WikittyService ws) {
        ArrayList exts = new ArrayList();
        exts.addAll(WikittyUserAbstract.extensions);
        exts.addAll(WikittyLabelAbstract.extensions);
        exts.addAll(WikittyTreeNodeAbstract.extensions);
        exts.addAll(WikittyPubTextAbstract.extensions);
        exts.addAll(WikittyPubDataAbstract.extensions);
        ws.storeExtension(null, exts);
    }

    public void parse(HttpServletRequest req, HttpServletResponse resp) {
        this.req = req;
        this.resp = resp;
        String path = req.getPathInfo();
        String[] comps = StringUtil.split((String)path, (String)"/");
        if (comps.length > 0) {
            this.wsContext = comps[1];
        }
        if (comps.length > 1) {
            this.actionName = comps[2];
        }
        for (int i = 3; i < comps.length; ++i) {
            this.mandatoryArguments.add(comps[i]);
            path = path + "/" + comps[i];
        }
        boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)this.getRequest());
        if (isMultipart) {
            DiskFileItemFactory factory = new DiskFileItemFactory();
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            try {
                List items = upload.parseRequest(this.getRequest());
                for (FileItem item : items) {
                    String name = item.getFieldName();
                    if (item.isFormField()) {
                        String value = item.getString();
                        this.arguments.put(name, value);
                        continue;
                    }
                    String filename = item.getName();
                    String mime = item.getContentType();
                    byte[] value = item.get();
                    log.info((Object)String.format("Argument file '%s' of type '%s'", filename, mime));
                    this.argumentFiles.put(name, value);
                    this.arguments.put(name + "-upload", "true");
                    this.arguments.put(name + "-filename", filename);
                    this.arguments.put(name + "-contentType", mime);
                }
            }
            catch (FileUploadException eee) {
                log.error((Object)"Can't get uploaded file", (Throwable)eee);
            }
        } else {
            Enumeration e = req.getParameterNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String value = req.getParameter(name);
                this.arguments.put(name, value);
            }
        }
        log.info((Object)String.format("path %s => ws: %s action: %s mandatoryArguments: %s arguments: %s", path, this.wsContext, this.actionName, this.mandatoryArguments, this.arguments));
    }

    public HttpServletRequest getRequest() {
        return this.req;
    }

    public HttpServletResponse getResponse() {
        return this.resp;
    }

    public ApplicationConfig getAppConfig() {
        return this.appConfig;
    }

    public String getActionName() {
        return this.actionName;
    }

    public String getPath() {
        return this.path;
    }

    public WikittyProxy getWikittyProxy() {
        if (this.proxy == null) {
            this.proxy = new WikittyProxy(this.getAppConfig(), this.getWikittyService());
        }
        return this.proxy;
    }

    public String makeUrl(String url) {
        String finalUrl = url;
        if (!finalUrl.startsWith("/")) {
            finalUrl = "/" + finalUrl;
        }
        finalUrl = this.getRequest().getContextPath() + "/" + this.wsContext + finalUrl;
        finalUrl = this.getResponse().encodeURL(finalUrl);
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("transforme url from '%s' to '%s'", url, finalUrl));
        }
        return finalUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WikittyService getWikittyService() {
        WikittyService result = (WikittyService)services.get(this.wsContext);
        if (result == null) {
            ApplicationConfig wsConfig;
            String patternConfigFilename = this.appConfig.getOption(CONFIG_FILE);
            String filename = String.format(patternConfigFilename, "default");
            log.info((Object)String.format("Try to load config file '%s'", filename));
            WikittyConfig wsConfigDefault = new WikittyConfig(filename);
            String dataDir = wsConfigDefault.getOption(WikittyConfig.WikittyOption.WIKITTY_DATA_DIR.getKey());
            wsConfigDefault.setOption(WikittyConfig.WikittyOption.WIKITTY_DATA_DIR.getKey(), dataDir + File.separator + this.wsContext);
            filename = String.format(patternConfigFilename, this.wsContext);
            log.info((Object)String.format("Try to load config file '%s'", filename));
            try {
                wsConfig = new ApplicationConfig(wsConfigDefault.getFlatOptions(false));
                wsConfig.setConfigFileName(filename);
                wsConfig.parse(null);
            }
            catch (ArgumentsParserException eee) {
                throw new WikittyException(String.format("Can't parse configuration %s", filename), (Throwable)eee);
            }
            Map map = services;
            synchronized (map) {
                result = (WikittyService)services.get(this.wsContext);
                if (result == null) {
                    result = WikittyServiceFactory.buildWikittyService((ApplicationConfig)wsConfig);
                    this.addRequiredExtension(result);
                    services.put(this.wsContext, result);
                }
            }
        }
        return result;
    }

    public List<String> getMandatoryArguments() {
        return this.mandatoryArguments;
    }

    public Map<String, String> getArguments() {
        return this.arguments;
    }

    public Map<String, byte[]> getArgumentFiles() {
        return this.argumentFiles;
    }

    public String getArgument(String name, String defaultValue) {
        String result = defaultValue;
        if (this.getArguments().containsKey(name)) {
            result = (String)this.getArguments().get(name);
        }
        return result;
    }

    public WikittyPublicationAction getAction() {
        WikittyPublicationAction result = this.getAction(this.actionName);
        return result;
    }

    public <E extends WikittyPublicationAction> E getAction(Class<E> actionClass) {
        WikittyPublicationAction result = null;
        for (WikittyPublicationAction a : actions.values()) {
            if (!actionClass.isInstance(a)) continue;
            result = a;
            break;
        }
        return (E)result;
    }

    public WikittyPublicationAction getAction(String actionName) {
        WikittyPublicationAction result;
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Looking for class for '%s' action", actionName));
        }
        if ((result = (WikittyPublicationAction)actions.get(actionName)) == null) {
            String action = "wikitty.publication.action." + actionName;
            log.info((Object)String.format("try to load action %s", action));
            try {
                Class clazz = this.appConfig.getOptionAsClass(action);
                Set<ApplicationConfig> args = Collections.singleton(this.appConfig);
                result = (WikittyPublicationAction)ObjectUtil.newInstance((Class)clazz, args, (boolean)true);
                result.setMapping(actionName);
                actions.put(actionName, result);
            }
            catch (Exception eee) {
                log.error((Object)String.format("Can't find action %s", action), (Throwable)eee);
                result = new ActionError((Throwable)eee);
            }
        }
        return result;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String toString() {
        String path = this.req.getPathInfo();
        String result = String.format("WPContext [path: %s\n ws: %s\n action: %s\n mandatoryArguments: %s\n arguments: %s\n]", path, this.wsContext, this.actionName, this.mandatoryArguments, this.arguments);
        return result;
    }
}

