/* *##%
 * Copyright (C) 2010 Code Lutin, Chatellier Eric
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *##%*/

package org.nuiton.wikitty.hessian;

import java.util.Properties;

import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyExtensionStorage;
import org.nuiton.wikitty.WikittySearchEngin;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceCached;
import org.nuiton.wikitty.WikittyServiceDelegator;
import org.nuiton.wikitty.WikittyServiceImpl;
import org.nuiton.wikitty.WikittyServiceNotifier;
import org.nuiton.wikitty.WikittyServiceSecurity;
import org.nuiton.wikitty.WikittyStorage;
import org.nuiton.wikitty.jdbc.WikittyExtensionStorageJDBC;
import org.nuiton.wikitty.jdbc.WikittyStorageJDBC;
import org.nuiton.wikitty.solr.WikittySearchEnginSolr;

/**
 * Hesian service delegator.
 * 
 * Based on empty constructor mandatory for some purpose (hessian), and
 * wikitty service factory to get delegated service.
 * 
 * @author chatellier
 * @version $Revision: 212 $
 * 
 * Last update : $Date: 2010-07-30 16:02:27 +0200 (ven., 30 juil. 2010) $
 * By : $Author: echatellier $
 */
public class WikittyServiceHessianDelegator extends WikittyServiceDelegator {

    /** Configuration file name for application config. */
    protected static final String WIKITTY_HESSIAN_CONFIGURATION_FILE = "wikitty-hessian.properties";

    /**
     * Unique empty constructor.
     * 
     * @throws WikittyException if delegated service can't be obtained
     */
    public WikittyServiceHessianDelegator() throws WikittyException {

        super();

        try {
            // load configuration
            ApplicationConfig config = new ApplicationConfig();
            config.setConfigFileName(WIKITTY_HESSIAN_CONFIGURATION_FILE);
            config.parse(new String[0]);
            
            // get configuration as properties
            Properties properties = config.getFlatOptions();

            // make impl instance of wikitty service
            WikittyExtensionStorage extensionStorage = new WikittyExtensionStorageJDBC(properties);
            WikittyStorage wikittyStorage = new WikittyStorageJDBC(extensionStorage, properties);
            WikittySearchEngin searchEngin = new WikittySearchEnginSolr(extensionStorage, properties);
            
            // make the chosen one IMPL
            WikittyService service = new WikittyServiceImpl(extensionStorage, wikittyStorage, searchEngin);

            // add security
            if (config.getOptionAsBoolean("wikitty.hessian.usesecurity")) {
                service = new WikittyServiceSecurity(service);
            }

            // add cache ?
            if (config.getOptionAsBoolean("wikitty.hessian.usecache")) {
                service = new WikittyServiceCached(service, properties);
            }

            // add notification
            if (config.getOptionAsBoolean("wikitty.hessian.usenotification")) {
                service = new WikittyServiceNotifier(service, properties);
            }

            // set delegate service
            setDelegate(service);
        }
        catch (Exception eee) {
            throw new WikittyException("Can't get delegate proxy", eee);
        }
        
    }
}
