/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.dto;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ObjectUtil;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.entities.BusinessEntity;

public class DTOHelper {
    static Log log = LogFactory.getLog(DTOHelper.class);

    public static <E extends BusinessEntity> E toDto(E w) {
        BusinessEntity result = null;
        if (w != null) {
            Class<?> clazz = w.getClass();
            String dtoClassName = clazz.getName().replace("Impl", "DTO").replace("CopyOnWrite", "DTO");
            try {
                String wikittyId = w.getWikittyId();
                result = (BusinessEntity)ObjectUtil.newInstance((String)(dtoClassName + "(" + wikittyId + ")"));
                result.copyFrom(w);
            }
            catch (Exception eee) {
                log.error((Object)"Could not transform Wikitty to DTO", (Throwable)eee);
            }
        }
        return (E)result;
    }

    public static <E extends BusinessEntity> E fromDto(WikittyProxy proxy, Class<E> clazz, E dto) {
        BusinessEntity result = proxy.restore(clazz, dto.getWikittyId());
        result.copyFrom(dto);
        return (E)result;
    }
}

