/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.templates;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.AbstractGenerator;
import org.nuiton.eugene.EugeneCoreTagValues;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.java.JavaGeneratorUtil;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.extension.tagvalue.TagValueMetadata;
import org.nuiton.eugene.models.extension.tagvalue.TagValueUtil;
import org.nuiton.eugene.models.extension.tagvalue.WithTagValuesOrStereotypes;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAssociationClass;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelPackage;
import org.nuiton.eugene.models.object.ObjectModelParameter;
import org.nuiton.topia.templates.DbNamingStrategy;
import org.nuiton.topia.templates.TopiaCoreTagValues;
import org.nuiton.topia.templates.TopiaHibernateTagValues;

public class TopiaTemplateHelper {
    private static final Log log = LogFactory.getLog(TopiaTemplateHelper.class);
    public final String PERSISTENCE_TYPE_HIBERNATE = "hibernate";
    public final String PERSISTENCE_TYPE_DEFAULT = "hibernate";
    public final String PROPERTY_DEFAULT_PACKAGE = "defaultPackage";
    public final String DEFAULT_PACKAGE = "org.codelutin.malo";
    public final String DEFAULT_INHERITANCE_STRATEGY = "union-subclass";
    protected final ObjectModel model;
    protected final EugeneCoreTagValues eugeneTagValues;
    protected final TopiaCoreTagValues topiaCoreTagValues;
    protected final TopiaHibernateTagValues topiaHibernateTagValues;
    private static final Set<String> numberTypes = new HashSet<String>();
    private static final Set<String> textTypes = new HashSet<String>();
    private static final Set<String> booleanTypes = new HashSet<String>();
    private static final Set<String> primitiveTypes = new HashSet<String>();
    private static final Map<String, String> primitiveTypeToClass = new HashMap<String, String>();
    private static final String VOID_TYPE = "void";
    public final Comparator<ObjectModelClass> OBJECT_MODEL_CLASS_COMPARATOR = new Comparator<ObjectModelClass>(){

        @Override
        public int compare(ObjectModelClass o1, ObjectModelClass o2) {
            return o1.getQualifiedName().compareTo(o2.getQualifiedName());
        }
    };

    public TopiaTemplateHelper(ObjectModel model) {
        this.model = model;
        this.eugeneTagValues = new EugeneCoreTagValues();
        this.topiaCoreTagValues = new TopiaCoreTagValues();
        this.topiaHibernateTagValues = new TopiaHibernateTagValues();
    }

    @Deprecated
    public TopiaCoreTagValues getTopiaCoreTagValues() {
        return this.topiaCoreTagValues;
    }

    @Deprecated
    public TopiaHibernateTagValues getTopiaHibernateTagValues() {
        return this.topiaHibernateTagValues;
    }

    public String getPersistenceType(ObjectModelClassifier classifier) {
        String tag = this.topiaHibernateTagValues.getPersistenceTypeTagValue(classifier);
        if (tag == null) {
            tag = "hibernate";
        }
        return tag;
    }

    public String getDefaultPackage(AbstractGenerator<?> generator) {
        String packageName = generator.getProperty("defaultPackage");
        if (StringUtils.isBlank((CharSequence)packageName)) {
            packageName = "org.codelutin.malo";
        }
        return packageName;
    }

    public String getApplicationContextPackage(ObjectModelTransformerToJava transformer, ObjectModel model) {
        return transformer.getDefaultPackageName();
    }

    public String getPersistenceContextPackage(ObjectModelTransformerToJava transformer, ObjectModel model) {
        return transformer.getDefaultPackageName();
    }

    public String getDaoPackage(ObjectModelTransformerToJava transformer, ObjectModel model) {
        return transformer.getDefaultPackageName();
    }

    public String getParentDaoName(ObjectModel model) {
        return "Abstract" + model.getName() + "TopiaDao";
    }

    public String getParentDaoFqn(ObjectModelTransformerToJava transformer, ObjectModel model) {
        return this.getDaoPackage(transformer, model) + "." + this.getParentDaoName(model);
    }

    public String getApplicationContextInterfaceName(ObjectModel model) {
        return model.getName() + "ApplicationContext";
    }

    public String getApplicationContextAbstractName(ObjectModel model) {
        return "Abstract" + model.getName() + "TopiaApplicationContext";
    }

    public String getApplicationContextConcreteName(ObjectModel model) {
        return model.getName() + "TopiaApplicationContext";
    }

    public String getPersistenceContextAbstractName(ObjectModel model) {
        return "Abstract" + model.getName() + "TopiaPersistenceContext";
    }

    public String getPersistenceContextConcreteName(ObjectModel model) {
        return model.getName() + "TopiaPersistenceContext";
    }

    public String getPersistenceContextInterfaceName(ObjectModel model) {
        return model.getName() + "PersistenceContext";
    }

    public String getDaoSupplierInterfaceName(ObjectModel model) {
        return model.getName() + "DaoSupplier";
    }

    public String getDaoSupplierName(ObjectModel model) {
        return model.getName() + "TopiaDaoSupplier";
    }

    public String getEntityEnumName(ObjectModel model) {
        return model.getName() + "EntityEnum";
    }

    public String getEntityAbstractName(ObjectModelClass input) {
        return input.getName() + "Abstract";
    }

    public String getEntityConcreteName(ObjectModelClass input) {
        return input.getName();
    }

    public String getAbstractDaoName(ObjectModelClass input) {
        return "Abstract" + input.getName() + "TopiaDao";
    }

    public String getGeneratedDaoName(ObjectModelClass input) {
        return "Generated" + input.getName() + "TopiaDao";
    }

    public String getConcreteDaoName(ObjectModelClass input) {
        return input.getName() + "TopiaDao";
    }

    public String getContractDaoName(ObjectModelClass input) {
        return input.getName() + "Dao";
    }

    public String getAbstractDaoFqn(ObjectModelClass input) {
        return input.getPackageName() + "." + this.getAbstractDaoName(input);
    }

    public String getGeneratedDaoFqn(ObjectModelClass input) {
        return input.getPackageName() + "." + this.getGeneratedDaoName(input);
    }

    public String getConcreteDaoFqn(ObjectModelClass input) {
        return input.getPackageName() + "." + this.getConcreteDaoName(input);
    }

    public String getEntityPackage(ObjectModelTransformerToJava transformer, ObjectModel model, ObjectModelClassifier input) {
        return input.getPackageName();
    }

    public String getReverseDbName(ObjectModelAttribute attr, ObjectModelPackage aPackage, ObjectModel model) {
        Object result = TagValueUtil.findDirectTagValue((TagValueMetadata)TopiaHibernateTagValues.Store.reverseDbName, (WithTagValuesOrStereotypes[])new WithTagValuesOrStereotypes[]{attr});
        if (StringUtils.isEmpty((CharSequence)result)) {
            result = attr.getReverseAttribute() != null ? this.getDbName((ObjectModelElement)attr.getReverseAttribute(), aPackage, model) : this.getDbName((ObjectModelElement)attr, aPackage, model) + "_id";
        }
        return result;
    }

    public String getDbName(ObjectModelElement element, ObjectModelPackage aPackage, ObjectModel model) {
        if (element == null) {
            return null;
        }
        String value = this.topiaHibernateTagValues.getDbNameTagValue(element);
        if (value != null) {
            return value;
        }
        DbNamingStrategy dbNamingStrategy = this.topiaHibernateTagValues.getDbNamingStrategyTagValue(new WithTagValuesOrStereotypes[]{element, aPackage, model});
        return dbNamingStrategy.apply(element.getName());
    }

    public String getColumnName(String elementName, ObjectModelPackage aPackage, ObjectModel model) {
        if (elementName == null) {
            return null;
        }
        DbNamingStrategy dbNamingStrategy = this.topiaHibernateTagValues.getDbNamingStrategyTagValue(new WithTagValuesOrStereotypes[]{aPackage, model});
        return dbNamingStrategy.apply(elementName);
    }

    public String getReverseDbNameOnReverseAttribute(ObjectModelAttribute attr, ObjectModelPackage aPackage, ObjectModel model) {
        ObjectModelAttribute reverseAttribute = attr.getReverseAttribute();
        if (reverseAttribute == null) {
            throw new IllegalArgumentException("The reverse attribute can't be null, but was on " + String.valueOf(attr));
        }
        String result = this.getReverseDbName(reverseAttribute, aPackage, model);
        if (StringUtils.isEmpty((CharSequence)result)) {
            ObjectModelAttribute reverseAttribute2 = reverseAttribute.getClassifier().getAttribute(attr.getName());
            result = this.getReverseDbName(reverseAttribute2, aPackage, model);
        }
        if (StringUtils.isEmpty((CharSequence)result)) {
            result = GeneratorUtil.toLowerCaseFirstLetter((String)reverseAttribute.getName());
        }
        return result;
    }

    public Set<ObjectModelAttribute> getNaturalIdAttributes(ObjectModelClass clazz) {
        LinkedHashSet<ObjectModelAttribute> results = new LinkedHashSet<ObjectModelAttribute>();
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (!this.topiaHibernateTagValues.getNaturalIdTagValue(attr)) continue;
            results.add(attr);
        }
        Collection superclasses = clazz.getSuperclasses();
        for (ObjectModelClass superClass : superclasses) {
            Set<ObjectModelAttribute> naturalIdsOfSuperClass = this.getNaturalIdAttributes(superClass);
            results.addAll(naturalIdsOfSuperClass);
        }
        return results;
    }

    public Set<ObjectModelAttribute> getNotNullAttributes(ObjectModelClass clazz) {
        LinkedHashSet<ObjectModelAttribute> results = new LinkedHashSet<ObjectModelAttribute>();
        for (Object attr : clazz.getAttributes()) {
            if (!this.isAttributeNotNull((ObjectModelAttribute)attr)) continue;
            results.add((ObjectModelAttribute)attr);
        }
        Collection superclasses = clazz.getSuperclasses();
        for (ObjectModelClass superClass : superclasses) {
            Set<ObjectModelAttribute> notNullOfSuperClass = this.getNotNullAttributes(superClass);
            results.addAll(notNullOfSuperClass);
        }
        if (clazz instanceof ObjectModelAssociationClass) {
            List participantsAttributes = ((ObjectModelAssociationClass)clazz).getParticipantsAttributes();
            results.addAll(participantsAttributes);
        }
        return results;
    }

    public boolean isAttributeNotNull(ObjectModelAttribute attribute) {
        Boolean value = this.topiaHibernateTagValues.getNotNullTagValue(attribute);
        if (value == null) {
            return this.topiaHibernateTagValues.getNaturalIdTagValue(attribute);
        }
        return value;
    }

    public String getDOType(ObjectModelElement elem, ObjectModel model) {
        String type = elem.getName();
        if (elem instanceof ObjectModelAttribute) {
            type = ((ObjectModelAttribute)elem).getType();
        }
        if (elem instanceof ObjectModelClass) {
            type = ((ObjectModelClass)elem).getQualifiedName();
        }
        return this.getDOType(type, model);
    }

    public String getDOType(String type, ObjectModel model) {
        if (!model.hasClass((String)type)) {
            return type;
        }
        ObjectModelClass clazz = model.getClass((String)type);
        if (this.isEntity((ObjectModelClassifier)clazz)) {
            type = (String)type + "Impl";
        }
        return type;
    }

    public boolean isNumericType(ObjectModelAttribute attr) {
        return numberTypes.contains(attr.getType());
    }

    public boolean isTextType(ObjectModelAttribute attr) {
        return textTypes.contains(attr.getType());
    }

    public boolean isDateType(ObjectModelAttribute attr) {
        return "java.util.Date".equals(attr.getType());
    }

    public boolean isBooleanType(ObjectModelAttribute attr) {
        return booleanTypes.contains(attr.getType());
    }

    public boolean isPrimitiveType(ObjectModelAttribute attr) {
        return primitiveTypes.contains(attr.getType());
    }

    public String getClassForPrimitiveType(ObjectModelAttribute attr) {
        Preconditions.checkState((boolean)this.isPrimitiveType(attr));
        String className = primitiveTypeToClass.get(attr.getType());
        Preconditions.checkNotNull((Object)className);
        return className;
    }

    public boolean hasUnidirectionalRelationOnAbstractType(ObjectModelAttribute attr, ObjectModel model) {
        ObjectModelClass clazz;
        ObjectModelAttribute reverse = attr.getReverseAttribute();
        if (reverse != null && GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr) && !GeneratorUtil.isNMultiplicity((ObjectModelAttribute)reverse) && !reverse.isNavigable() && (clazz = model.getClass(attr.getType())) != null && this.isEntity((ObjectModelClassifier)clazz)) {
            for (ObjectModelClass subClass : model.getClasses()) {
                if (!subClass.getSuperclasses().contains(clazz)) continue;
                return true;
            }
        }
        return false;
    }

    public String getManyToManyTableName(ObjectModelAttribute attr, ObjectModelPackage aPackage, ObjectModel model) {
        Object result;
        if (attr.hasAssociationClass()) {
            result = this.getDbName((ObjectModelElement)attr.getAssociationClass(), aPackage, model);
        } else {
            result = this.topiaHibernateTagValues.getManytoManyTableNameTagValue(attr);
            if (StringUtils.isEmpty((CharSequence)result)) {
                String revers;
                String name = attr.getName();
                result = name.compareToIgnoreCase(revers = attr.getReverseAttributeName()) < 0 ? name + "_" + revers : revers + "_" + name;
            }
        }
        return ((String)result).toLowerCase();
    }

    public String getNMultiplicityHibernateType(ObjectModelAttribute attr) {
        if (JavaGeneratorUtil.isOrdered((ObjectModelAttribute)attr)) {
            return "list";
        }
        if (EugeneCoreTagValues.isUnique((ObjectModelAttribute)attr)) {
            return "set";
        }
        return "bag";
    }

    public List<ObjectModelClass> getEntityClasses(ObjectModel model, boolean sort) {
        ArrayList<ObjectModelClass> classes = new ArrayList<ObjectModelClass>();
        for (ObjectModelClass clazz : model.getClasses()) {
            if (!this.isEntity((ObjectModelClassifier)clazz)) continue;
            classes.add(clazz);
        }
        if (sort && !classes.isEmpty()) {
            Collections.sort(classes, this.OBJECT_MODEL_CLASS_COMPARATOR);
        }
        return classes;
    }

    public List<String> getImports(ObjectModelClass aClass, String ... incomingFqns) {
        HashSet<String> tmp = new HashSet<String>();
        tmp.addAll(Arrays.asList(incomingFqns));
        this.getImports(aClass, tmp);
        return this.cleanImports(aClass.getPackageName(), tmp);
    }

    public void getImports(ObjectModelClass aClass, Set<String> fqns) {
        for (ObjectModelAttribute attr : aClass.getAttributes()) {
            fqns.add(attr.getType());
            if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) continue;
            String collectionType = this.getCollectionType(attr).getName();
            fqns.add(collectionType);
            String collectionObject = this.getCollectionInstanceType(attr).getName();
            fqns.add(collectionObject);
        }
        for (Object attribute : aClass.getAllOtherAttributes()) {
            fqns.add(attribute.getType());
        }
        if (aClass instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass assoc = (ObjectModelAssociationClass)aClass;
            for (ObjectModelAttribute attr : assoc.getParticipantsAttributes()) {
                if (attr == null) continue;
                fqns.add(attr.getType());
                if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) continue;
                String collectionType = this.getCollectionType(attr).getName();
                fqns.add(collectionType);
                String collectionObject = this.getCollectionInstanceType(attr).getName();
                fqns.add(collectionObject);
            }
        }
        for (ObjectModelOperation operation : aClass.getOperations()) {
            this.getImports(operation, fqns);
        }
        for (ObjectModelInterface modelInterface : aClass.getInterfaces()) {
            fqns.add(modelInterface.getQualifiedName());
            this.getImports(modelInterface, fqns);
        }
        for (ObjectModelClass modelClass : aClass.getSuperclasses()) {
            fqns.add(modelClass.getQualifiedName());
            this.getImports(modelClass, new String[0]);
        }
    }

    public void getImports(ObjectModelInterface anInterface, Set<String> fqns) {
        for (ObjectModelOperation operation : anInterface.getOperations()) {
            this.getImports(operation, fqns);
        }
        for (ObjectModelInterface modelInterface : anInterface.getInterfaces()) {
            fqns.add(modelInterface.getQualifiedName());
            this.getImports(modelInterface, fqns);
        }
    }

    public void getImports(ObjectModelOperation operation, Set<String> fqns) {
        String fqn = operation.getReturnType();
        fqns.add(fqn);
        for (ObjectModelParameter parameter : operation.getParameters()) {
            fqns.add(parameter.getType());
        }
    }

    public List<String> cleanImports(String packageName, Set<String> fqns) {
        fqns.removeAll(primitiveTypes);
        fqns.remove(VOID_TYPE);
        int packageLength = packageName.length();
        ArrayList<String> genericType = new ArrayList<String>();
        Iterator<String> it = fqns.iterator();
        while (it.hasNext()) {
            String fqn = it.next();
            int lastIndex = fqn.lastIndexOf(".");
            if (lastIndex == packageLength && fqn.startsWith(packageName)) {
                it.remove();
                continue;
            }
            int genericIndex = fqn.indexOf(60);
            if (genericIndex == -1) continue;
            genericType.add(fqn.substring(0, genericIndex));
            it.remove();
        }
        fqns.addAll(genericType);
        ArrayList<String> result = new ArrayList<String>(fqns);
        Collections.sort(result);
        return result;
    }

    public Map<ObjectModelClass, Set<ObjectModelClass>> searchDirectUsages(ObjectModel model) {
        List<ObjectModelClass> allEntities = this.getEntityClasses(model, true);
        TreeMap<String, ObjectModelClass> allEntitiesByFQN = new TreeMap<String, ObjectModelClass>();
        LinkedHashMap<ObjectModelClass, Set<ObjectModelClass>> usages = new LinkedHashMap<ObjectModelClass, Set<ObjectModelClass>>();
        for (ObjectModelClass klass : allEntities) {
            usages.put(klass, new HashSet());
            allEntitiesByFQN.put(klass.getQualifiedName(), klass);
        }
        for (ObjectModelClass klass : allEntities) {
            this.searchDirectUsages(klass, allEntitiesByFQN, usages);
        }
        allEntities.clear();
        allEntitiesByFQN.clear();
        return usages;
    }

    public void searchDirectUsages(ObjectModelClass klass, Map<String, ObjectModelClass> allEntitiesByFQN, Map<ObjectModelClass, Set<ObjectModelClass>> usages) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("for entity " + klass.getQualifiedName()));
        }
        for (ObjectModelAttribute attr : klass.getAttributes()) {
            String type;
            if (!attr.isNavigable() || !allEntitiesByFQN.containsKey(type = attr.hasAssociationClass() ? attr.getAssociationClass().getQualifiedName() : attr.getType())) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)(" uses " + type));
            }
            ObjectModelClass targetEntity = allEntitiesByFQN.get(type);
            Set<ObjectModelClass> classes = usages.get(targetEntity);
            classes.add(klass);
        }
    }

    public boolean isImportNeeded(Collection<ObjectModelOperation> operations, String importName) {
        if (CollectionUtils.isNotEmpty(operations)) {
            for (ObjectModelOperation op : operations) {
                if (op.getReturnType().contains(importName)) {
                    return true;
                }
                for (ObjectModelParameter param : op.getParameters()) {
                    if (!param.getType().contains(importName)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isCollectionNeeded(Collection<ObjectModelOperation> operations) {
        return this.isImportNeeded(operations, Collection.class.getSimpleName());
    }

    public boolean isSetNeeded(Collection<ObjectModelOperation> operations) {
        return this.isImportNeeded(operations, Set.class.getSimpleName());
    }

    public boolean isEntity(ObjectModelAttribute attribute, ObjectModel model) {
        if (this.isPrimitiveType(attribute)) {
            return false;
        }
        String attributeType = attribute.getType();
        ObjectModelClassifier typeclassifier = model.getClassifier(attributeType);
        return typeclassifier != null && this.isEntity(typeclassifier);
    }

    public boolean isEntity(ObjectModelClassifier classifier) {
        ObjectModelPackage aPackage = this.model.getPackage(classifier);
        return !classifier.isEnum() && this.topiaCoreTagValues.isEntity(classifier, aPackage);
    }

    public boolean isAbstract(ObjectModelClassifier classifier) {
        ObjectModelClass aClass = this.model.getClass(classifier.getQualifiedName());
        return aClass.isAbstract();
    }

    public String getInheritanceStrategy(ObjectModelClassifier classifier) {
        ObjectModelPackage aPackage = this.model.getPackage(classifier);
        String value = this.topiaHibernateTagValues.getInheritanceStrategyTagValue(classifier, aPackage);
        if (value == null) {
            value = "union-subclass";
        }
        return value;
    }

    public Class<?> getCollectionType(ObjectModelAttribute attribute) {
        return JavaGeneratorUtil.getCollectionType((ObjectModelAttribute)attribute);
    }

    public Class<?> getCollectionInstanceType(ObjectModelAttribute attribute) {
        boolean unique = EugeneCoreTagValues.isUnique((ObjectModelAttribute)attribute);
        boolean ordered = EugeneCoreTagValues.isOrdered((ObjectModelAttribute)attribute);
        boolean orderBy = this.topiaHibernateTagValues.getOrderByTagValue(attribute) != null;
        Class<LinkedHashSet> result = unique && orderBy && !ordered ? LinkedHashSet.class : JavaGeneratorUtil.getCollectionInstanceType((ObjectModelAttribute)attribute);
        return result;
    }

    @Deprecated
    public static String getLegacyDaoName(ObjectModelClass input) {
        return input.getName() + "DAO";
    }

    static {
        primitiveTypeToClass.put("byte", "java.lang.Byte");
        primitiveTypeToClass.put("short", "java.lang.Short");
        primitiveTypeToClass.put("int", "java.lang.Integer");
        primitiveTypeToClass.put("long", "java.lang.Long");
        primitiveTypeToClass.put("float", "java.lang.Float");
        primitiveTypeToClass.put("double", "java.lang.Double");
        primitiveTypeToClass.put("char", "java.lang.Char");
        primitiveTypeToClass.put("boolean", "java.lang.Boolean");
        numberTypes.add("byte");
        numberTypes.add("java.lang.Byte");
        numberTypes.add("Byte");
        numberTypes.add("short");
        numberTypes.add("java.lang.Short");
        numberTypes.add("Short");
        numberTypes.add("int");
        numberTypes.add("java.lang.Integer");
        numberTypes.add("Integer");
        numberTypes.add("long");
        numberTypes.add("java.lang.Long");
        numberTypes.add("Long");
        numberTypes.add("float");
        numberTypes.add("java.lang.Float");
        numberTypes.add("Float");
        numberTypes.add("double");
        numberTypes.add("java.lang.Double");
        numberTypes.add("Double");
        textTypes.add("char");
        textTypes.add("java.lang.Char");
        textTypes.add("Char");
        textTypes.add("java.lang.String");
        textTypes.add("String");
        booleanTypes.add("boolean");
        booleanTypes.add("java.lang.Boolean");
        booleanTypes.add("Boolean");
        primitiveTypes.addAll(numberTypes);
        primitiveTypes.addAll(textTypes);
        primitiveTypes.addAll(booleanTypes);
    }
}

