/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.service.sql.batch.actions;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import javax.sql.rowset.serial.SerialBlob;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.service.sql.batch.actions.AbstractTablesAction;
import org.nuiton.topia.service.sql.batch.actions.UpdateTablesRequest;
import org.nuiton.topia.service.sql.batch.tables.TopiaSqlTable;

public class UpdateTablesAction
extends AbstractTablesAction<UpdateTablesRequest> {
    public static final String UPDATE_STATEMENT = "UPDATE %s.%s %s WHERE topiaid='%%s'";
    private static final Log log = LogFactory.getLog(UpdateTablesAction.class);

    public UpdateTablesAction(UpdateTablesRequest request) {
        super(request);
    }

    @Override
    protected void executeOnTable(UpdateTablesRequest request, TopiaSqlTable table, PreparedStatement readStatement) throws SQLException {
        ResultSet readResultSet = readStatement.getResultSet();
        ResultSetMetaData readResultSetMetaData = readResultSet.getMetaData();
        int columnCount = readResultSetMetaData.getColumnCount();
        ArrayList columnNames = Lists.newArrayList(this.getColumnNames(readResultSetMetaData, columnCount));
        String topiaIdColumnName = "topiaId".toLowerCase();
        int topiaIdColumnIndex = columnNames.indexOf(topiaIdColumnName);
        columnNames.remove(topiaIdColumnName);
        boolean useOutputWriter = this.useOutputWriter();
        boolean useOutputDb = this.useOutputDb();
        PreparedStatement writeStatement = null;
        String updateStatementSql = this.newUpdateStatementSql(table, columnNames);
        if (useOutputDb) {
            String arguments = this.generateWildcardArguments(columnNames);
            String sql = String.format(updateStatementSql, arguments, "?");
            writeStatement = this.targetConnection.prepareStatement(sql);
        }
        int writeBatchSize = request.getWriteBatchSize();
        String tableName = table.getFullyTableName();
        long index = 0L;
        while (readResultSet.next()) {
            String topiaId = readResultSet.getString(topiaIdColumnIndex);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Update " + readResultSet.getString(1)));
            }
            if (useOutputDb) {
                writeStatement.clearParameters();
                int i = 1;
                for (String columnName : columnNames) {
                    Object object = readResultSet.getObject(columnName);
                    writeStatement.setObject(i++, object);
                }
                writeStatement.setString(columnCount + 1, topiaId);
                writeStatement.addBatch();
            }
            if (useOutputWriter) {
                try {
                    String arguments = this.generateArguments(columnNames, readResultSet);
                    String sql = String.format(updateStatementSql, arguments, topiaId);
                    this.writer.append(sql);
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not updateRow", e);
                }
            }
            if (++index % (long)writeBatchSize != 0L) continue;
            this.flush(writeStatement, this.writer, tableName, index);
        }
        this.flush(writeStatement, this.writer, tableName, index);
    }

    protected String generateArguments(Iterable<String> columnNames, ResultSet readResultSet) throws SQLException, IOException {
        String statement = "";
        for (String columnName : columnNames) {
            statement = statement + ", SET " + columnName + " = ";
            Object columnValue = readResultSet.getObject(columnName);
            if (columnValue == null) {
                statement = statement + "NULL";
                continue;
            }
            if (columnValue instanceof String) {
                String stringValue = (String)columnValue;
                statement = statement + "'" + stringValue.replaceAll("'", "''") + "'";
                continue;
            }
            if (columnValue instanceof Date) {
                statement = statement + "'" + columnValue + "'";
                continue;
            }
            if (columnValue instanceof Blob) {
                Blob blob = (Blob)columnValue;
                SerialBlob serialBlob = new SerialBlob(blob);
                ByteArrayOutputStream stringWriter = new ByteArrayOutputStream((int)serialBlob.length());
                Throwable throwable = null;
                try {
                    stringWriter.write(serialBlob.getBinaryStream());
                    statement = statement + "'" + new String(stringWriter.toByteArray()) + "'";
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stringWriter == null) continue;
                    if (throwable != null) {
                        try {
                            stringWriter.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    stringWriter.close();
                    continue;
                }
            }
            statement = statement + columnValue;
        }
        return statement.substring(2);
    }

    protected String newUpdateStatementSql(TopiaSqlTable table, Iterable<String> columnNames) throws SQLException {
        StringBuilder columnNamesBuilder = new StringBuilder();
        for (String columnName : columnNames) {
            columnNamesBuilder.append(", SET ").append(columnName).append(" = ?");
        }
        String sql = String.format(UPDATE_STATEMENT, table.getSchemaName(), table.getTableName(), columnNamesBuilder.substring(2));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Insert sql: " + sql));
        }
        return sql;
    }
}

