/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.service.sql.batch.actions;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Properties;
import org.apache.commons.io.output.WriterOutputStream;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.service.sql.batch.actions.AbstractSchemaAction;
import org.nuiton.topia.service.sql.batch.actions.DropSchemaRequest;

public class DropSchemaAction
extends AbstractSchemaAction<DropSchemaRequest> {
    public static final String DROP_SCHEMA_STATEMENT = "\nDROP SCHEMA %s;";

    public DropSchemaAction(DropSchemaRequest request) {
        super(request);
    }

    @Override
    protected String produceSql(Class<? extends Dialect> dialectType, Path temporaryDirectory) throws IOException {
        try {
            Path sqlScriptFile = temporaryDirectory.resolve("replicateSchema_" + System.nanoTime() + ".sql");
            Configuration hibernateConfiguration = this.getSourcePersistenceContext().getHibernateSupport().getHibernateConfiguration();
            Properties properties = new Properties();
            properties.put("hibernate.dialect", dialectType.getName());
            new SchemaExport(hibernateConfiguration, properties).setOutputFile(sqlScriptFile.toFile().getAbsolutePath()).setDelimiter(";").drop(false, false);
            WriterOutputStream out = new WriterOutputStream(this.writer);
            Files.copy(sqlScriptFile, (OutputStream)out);
            out.flush();
            String sqlContent = new String(Files.readAllBytes(sqlScriptFile));
            Files.delete(sqlScriptFile);
            if (((DropSchemaRequest)this.request).isDropSchema()) {
                ImmutableSet<String> schemaNames = this.getSchemaNames();
                for (String schemaName : schemaNames) {
                    sqlContent = sqlContent + String.format(DROP_SCHEMA_STATEMENT, schemaName);
                }
            }
            return sqlContent;
        }
        catch (HibernateException eee) {
            throw new TopiaException(String.format("Could not create schema for reason: %s", eee.getMessage()), (Throwable)eee);
        }
    }
}

