/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.service.sql.batch.actions;

import java.io.IOException;
import java.io.Writer;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.sql.rowset.serial.SerialBlob;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.support.TopiaSqlWork;
import org.nuiton.topia.service.sql.batch.actions.AbstractSqlAction;
import org.nuiton.topia.service.sql.batch.actions.AbstractTablesRequest;
import org.nuiton.topia.service.sql.batch.actions.TopiaSqlTableSelectArgument;
import org.nuiton.topia.service.sql.batch.tables.TopiaSqlTable;
import org.nuiton.util.TimeLog;

public abstract class AbstractTablesAction<R extends AbstractTablesRequest>
extends AbstractSqlAction<R> {
    private static final Log log = LogFactory.getLog(AbstractTablesAction.class);

    protected AbstractTablesAction(R request) {
        super(request);
    }

    protected abstract void executeOnTable(R var1, TopiaSqlTable var2, PreparedStatement var3) throws SQLException;

    @Override
    protected final void execute() {
        for (TopiaSqlTable table : ((AbstractTablesRequest)this.request).getTables()) {
            long startTable = TimeLog.getTime();
            ReadSqlWork sqlWork = new ReadSqlWork(this, (AbstractTablesRequest)this.request, table);
            this.executeSqlWork(sqlWork);
            TIME_LOG.log(startTable, "Executed on table.", table.getFullyTableName());
        }
    }

    protected String generateSqlArguments(ResultSet readResultSet, Iterable<String> columnNames) throws SQLException, IOException {
        String statement = "";
        for (String columnName : columnNames) {
            Object columnValue = readResultSet.getObject(columnName);
            if (columnValue == null) {
                statement = statement + ", NULL";
                continue;
            }
            if (columnValue instanceof String) {
                String stringValue = (String)columnValue;
                statement = statement + ", '" + stringValue.replaceAll("'", "''") + "'";
                continue;
            }
            if (columnValue instanceof Date) {
                statement = statement + ", '" + columnValue + "'";
                continue;
            }
            if (columnValue instanceof Blob) {
                Blob blob = (Blob)columnValue;
                SerialBlob serialBlob = new SerialBlob(blob);
                ByteArrayOutputStream stringWriter = new ByteArrayOutputStream((int)serialBlob.length());
                Throwable throwable = null;
                try {
                    stringWriter.write(serialBlob.getBinaryStream());
                    statement = statement + ", '" + new String(stringWriter.toByteArray()) + "'";
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stringWriter == null) continue;
                    if (throwable != null) {
                        try {
                            stringWriter.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    stringWriter.close();
                    continue;
                }
            }
            statement = statement + ", " + columnValue;
        }
        return statement.substring(2);
    }

    protected String generateWildcardArguments(Iterable<String> columnNames) throws SQLException {
        StringBuilder argsBuilder = new StringBuilder();
        for (String ignored : columnNames) {
            argsBuilder.append(", ?");
        }
        return argsBuilder.substring(2);
    }

    protected void flush(PreparedStatement writeStatement, Writer writer, String tableName, long index) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Flush for : " + tableName + " (size: " + index + ")"));
        }
        if (writeStatement != null) {
            writeStatement.executeBatch();
            writeStatement.clearBatch();
        }
        if (writer != null) {
            AbstractTablesAction.flush(writer);
        }
    }

    protected List<String> getColumnNames(ResultSetMetaData readResultTatMetaData, int columnCount) throws SQLException {
        ArrayList<String> builder = new ArrayList<String>(columnCount);
        for (int i = 1; i <= columnCount; ++i) {
            builder.add(readResultTatMetaData.getColumnName(i).toLowerCase());
        }
        return builder;
    }

    protected static class ReadSqlWork
    implements TopiaSqlWork {
        private final R request;
        private final TopiaSqlTable table;
        final /* synthetic */ AbstractTablesAction this$0;

        public ReadSqlWork(R request, TopiaSqlTable table) {
            this.this$0 = this$0;
            this.request = request;
            this.table = table;
        }

        public void execute(Connection connection) throws SQLException {
            try (PreparedStatement readStatement = this.createReadStatement(this.table, connection);){
                readStatement.execute();
                this.this$0.executeOnTable(this.request, this.table, readStatement);
            }
        }

        protected PreparedStatement createReadStatement(TopiaSqlTable table, Connection connection) throws SQLException {
            boolean filter;
            StringBuilder sqlBuilder = new StringBuilder("SELECT " + table.getTableName() + ".*");
            sqlBuilder.append(" FROM ").append(table.getFromClause());
            for (String joinClause : table.getJoinClauses()) {
                sqlBuilder.append(" ").append(joinClause);
            }
            TopiaSqlTableSelectArgument selectArgument = ((AbstractTablesRequest)this.request).getSelectArgument();
            boolean bl = filter = selectArgument != null;
            if (filter) {
                sqlBuilder.append(" WHERE ").append(table.getWhereClause(selectArgument.getIds()));
            }
            String sql = sqlBuilder.toString();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Read sql: " + sql));
            }
            PreparedStatement statement = connection.prepareStatement(sql);
            if (filter) {
                int index = 1;
                for (String id : selectArgument.getIds()) {
                    statement.setString(index++, id);
                }
            }
            statement.setFetchSize(((AbstractTablesRequest)this.request).getReadFetchSize());
            return statement;
        }
    }
}

