/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.jdbc;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.io.IOUtils;
import org.nuiton.topia.persistence.jdbc.JdbcConfiguration;
import org.nuiton.topia.persistence.jdbc.JdbcHelper;

public class JdbcH2Helper
extends JdbcHelper {
    public JdbcH2Helper(JdbcConfiguration jdbcConfiguration) {
        super(jdbcConfiguration);
    }

    public boolean isTableExist(String tableName) {
        return this.isTableExist(null, tableName);
    }

    public boolean isTableExist(String schema, String tableName) {
        boolean bl;
        Connection connection = null;
        ResultSet resultSet = null;
        try {
            boolean result;
            connection = this.openConnection();
            resultSet = connection.getMetaData().getTables(null, schema, tableName, null);
            bl = result = resultSet.next();
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.closeQuietly(resultSet);
                this.closeQuietly(connection);
                throw throwable;
            }
        }
        this.closeQuietly(resultSet);
        this.closeQuietly(connection);
        return bl;
    }

    public void backup(File file, boolean compress) {
        Object options = "";
        if (compress) {
            options = (String)options + " COMPRESSION GZIP";
        }
        this.runUpdate("SCRIPT TO '" + file.getAbsolutePath() + "'" + (String)options);
    }

    public void restore(File file) throws FileNotFoundException {
        Object options = "";
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            ((InputStream)in).mark(2);
            int b = ((InputStream)in).read();
            int magic = ((InputStream)in).read() << 8 | b;
            ((InputStream)in).reset();
            if (magic == 35615) {
                options = (String)options + " COMPRESSION GZIP";
            }
            ((InputStream)in).close();
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        this.runUpdate("RUNSCRIPT FROM '" + file.getAbsolutePath() + "'" + (String)options);
    }

    public void clear(boolean dropDatabase) {
        Object sql = "DROP ALL OBJECTS";
        if (dropDatabase) {
            sql = (String)sql + " DELETE FILES";
        }
        this.runUpdate((String)sql);
    }
}

