/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.collections4.map.AbstractReferenceMap;
import org.apache.commons.collections4.map.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaApplicationContext;
import org.nuiton.topia.persistence.TopiaException;

public class TopiaApplicationContextCache {
    private static final Log log = LogFactory.getLog(TopiaApplicationContextCache.class);
    protected static Map<Properties, TopiaApplicationContext> contextCache = new ReferenceMap(AbstractReferenceMap.ReferenceStrength.HARD, AbstractReferenceMap.ReferenceStrength.SOFT);

    public static <C extends TopiaApplicationContext> C getContext(Properties config, Function<Properties, C> createContextFunction) {
        Properties cloned = new Properties();
        for (String key : config.stringPropertyNames()) {
            cloned.setProperty(key, config.getProperty(key));
        }
        TopiaApplicationContext result = contextCache.get(cloned);
        if (result == null || result.isClosed()) {
            if (createContextFunction == null) {
                throw new TopiaException("Function<Properties, AbstractTopiaApplicationContext> is required to create context");
            }
            result = (TopiaApplicationContext)createContextFunction.apply((Object)cloned);
            if (log.isDebugEnabled()) {
                log.debug((Object)("New context created : " + result));
            }
            contextCache.put(cloned, result);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Context found : " + result));
        }
        return (C)result;
    }

    public static List<String> getRegisteredContextUrls() {
        ArrayList result = Lists.newArrayList();
        for (Properties e : contextCache.keySet()) {
            result.add(e.getProperty("jakarta.persistence.jdbc.url"));
        }
        return result;
    }

    public static void removeContext(TopiaApplicationContext context) {
        Iterator<TopiaApplicationContext> it = contextCache.values().iterator();
        while (it.hasNext()) {
            TopiaApplicationContext curr = it.next();
            if (curr != context) continue;
            it.remove();
            break;
        }
    }
}

